/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.FloatingParserState;
import edu.stanford.nlp.sempre.Grammar;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.ParserState;
import edu.stanford.nlp.sempre.Rule;
import fig.basic.MapUtils;
import fig.basic.Option;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FloatingParser
extends Parser {
    public static Options opts = new Options();
    protected List<Rule> orderedFloatingRules;

    public List<Rule> getOrderedFloatingRules() {
        return this.orderedFloatingRules;
    }

    public FloatingParser(Parser.Spec spec) {
        super(spec);
    }

    @Override
    protected void computeCatUnaryRules() {
        this.catUnaryRules = new ArrayList();
        HashMap<String, List<Rule>> graph = new HashMap<String, List<Rule>>();
        for (Rule rule : this.grammar.rules) {
            if (!rule.isCatUnary() || !rule.isAnchored()) continue;
            MapUtils.addToList(graph, (Object)rule.lhs, (Object)rule);
        }
        HashMap<String, Boolean> done = new HashMap<String, Boolean>();
        for (String node : graph.keySet()) {
            this.traverse(this.catUnaryRules, node, graph, done);
        }
        for (Rule rule : this.grammar.rules) {
            if (!rule.isCatUnary() || !rule.isFloating()) continue;
            this.catUnaryRules.add(rule);
        }
    }

    protected void traverseFloatingRules(List<Rule> orderedFloatingRules, String node, Map<String, List<Rule>> graph, Map<String, Boolean> done) {
        Boolean d = done.get(node);
        if (Boolean.TRUE.equals(d)) {
            return;
        }
        if (Boolean.FALSE.equals(d)) {
            throw new RuntimeException("Found cycle of floating rules involving " + node);
        }
        done.put(node, false);
        for (Rule rule : MapUtils.getList(graph, (Object)node)) {
            for (String rhsCat : rule.rhs) {
                if (!Grammar.isIntermediate(rhsCat)) continue;
                this.traverseFloatingRules(orderedFloatingRules, rhsCat, graph, done);
            }
            orderedFloatingRules.add(rule);
        }
        done.put(node, true);
    }

    @Override
    public ParserState newParserState(Params params, Example ex, boolean computeExpectedCounts) {
        return new FloatingParserState(this, params, ex, computeExpectedCounts);
    }

    public static class Options {
        @Option(gloss="Whether rules without the (anchored 1) or (floating 1) tag should be anchored or floating")
        public boolean defaultIsFloating = true;
        @Option(gloss="Limit on formula depth (or formula size when --useSizeInsteadOfDepth is true)")
        public int maxDepth = 10;
        @Option(gloss="Put a limit on formula size instead of formula depth")
        public boolean useSizeInsteadOfDepth = false;
        @Option(gloss="Whether floating rules are allowed to be applied consecutively")
        public boolean consecutiveRules = true;
        @Option(gloss="Whether floating rule (rule $A (a)) should have depth 0 or 1")
        public boolean initialFloatingHasZeroDepth = false;
        @Option(gloss="Filter child derivations using the type information from SemanticFn")
        public boolean filterChildDerivations = true;
        @Option(gloss="Whether anchored spans/tokens can only be used once in a derivation")
        public boolean useAnchorsOnce = false;
        @Option(gloss="Each span can be anchored this number of times (unused if useAnchorsOnce is active)")
        public int useMaxAnchors = -1;
        @Option(gloss="Whether to always execute the derivation")
        public boolean executeAllDerivations = false;
        @Option(gloss="Whether to output a file with all utterances predicted")
        public boolean printPredictedUtterances = false;
        @Option(gloss="Custom beam size at training time (default = Parser.beamSize)")
        public int trainBeamSize = -1;
        @Option(gloss="Whether to beta reduce the formula")
        public boolean betaReduce = false;
        @Option(gloss="DEBUG: Print amount of time spent on each rule")
        public boolean summarizeRuleTime = false;
        @Option(gloss="Stop the parser if it has used more than this amount of time (in seconds)")
        public int maxFloatingParsingTime = 600;
    }
}

