/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.CatSizeBound;
import edu.stanford.nlp.sempre.ChildDerivationsGroup;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationPruner;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.ErrorValue;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.FloatingParser;
import edu.stanford.nlp.sempre.FloatingRuleUtils;
import edu.stanford.nlp.sempre.FuncSemType;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.ParserState;
import edu.stanford.nlp.sempre.Rule;
import edu.stanford.nlp.sempre.SemanticFn;
import fig.basic.IOUtils;
import fig.basic.ListUtils;
import fig.basic.LogInfo;
import fig.basic.MapUtils;
import fig.basic.StopWatch;
import fig.basic.ValueComparator;
import fig.exec.Execution;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class FloatingParserState
extends ParserState {
    private final Map<Object, List<Derivation>> chart = new HashMap<Object, List<Derivation>>();
    private final DerivationPruner pruner = new DerivationPruner(this);
    private final CatSizeBound catSizeBound;
    private Map<Rule, Long> ruleTime;
    private boolean timeout = false;

    public FloatingParserState(FloatingParser parser, Params params, Example ex, boolean computeExpectedCounts) {
        super(parser, params, ex, computeExpectedCounts);
        this.catSizeBound = new CatSizeBound(FloatingParser.opts.maxDepth, parser.grammar);
    }

    @Override
    protected int getBeamSize() {
        if (this.computeExpectedCounts && FloatingParser.opts.trainBeamSize > 0) {
            return FloatingParser.opts.trainBeamSize;
        }
        return Parser.opts.beamSize;
    }

    private Object floatingCell(String cat, int depth) {
        return (cat + ":" + depth).intern();
    }

    private Object anchoredCell(String cat, int start, int end) {
        return (cat + "[" + start + "," + end + "]").intern();
    }

    private Object cell(String cat, int start, int end, int depth) {
        return start != -1 ? this.anchoredCell(cat, start, end) : this.floatingCell(cat, depth);
    }

    private void addToChart(Object cell, Derivation deriv) {
        if (!deriv.isFeaturizedAndScored()) {
            this.featurizeAndScoreDerivation(deriv);
        }
        if (Parser.opts.pruneErrorValues && deriv.value instanceof ErrorValue) {
            return;
        }
        if (Parser.opts.verbose >= 4) {
            LogInfo.logs((String)"addToChart %s: %s", (Object[])new Object[]{cell, deriv});
        }
        MapUtils.addToList(this.chart, (Object)cell, (Object)deriv);
    }

    private boolean isRootRule(Rule rule) {
        return "$ROOT".equals(rule.lhs);
    }

    private boolean applyRule(Rule rule, int start, int end, int depth, Derivation child1, Derivation child2, String canonicalUtterance) {
        if (this.timeout && !this.isRootRule(rule)) {
            return false;
        }
        this.applyRuleActual(rule, start, end, depth, child1, child2, canonicalUtterance);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void applyRuleActual(Rule rule, int start, int end, int depth, Derivation child1, Derivation child2, String canonicalUtterance) {
        List<Object> children;
        if (Parser.opts.verbose >= 5) {
            LogInfo.logs((String)"applyRule %s [%s:%s] depth=%s, %s %s", (Object[])new Object[]{rule, start, end, depth, child1, child2});
        }
        if (child1 == null) {
            children = Collections.emptyList();
        } else if (child2 == null) {
            children = Collections.singletonList(child1);
        } else {
            if (FloatingParser.opts.useAnchorsOnce ? FloatingRuleUtils.derivationAnchorsOverlap(child1, child2) : FloatingParser.opts.useMaxAnchors >= 0 && FloatingRuleUtils.maxNumAnchorOverlaps(child1, child2) > FloatingParser.opts.useMaxAnchors) {
                return;
            }
            children = ListUtils.newList((Object[])new Derivation[]{child1, child2});
        }
        if (!FloatingParser.opts.consecutiveRules) {
            for (Derivation derivation : children) {
                if (!derivation.rule.equals(rule)) continue;
                return;
            }
        }
        DerivationStream results = rule.sem.call(this.ex, new SemanticFn.CallInfo(rule.lhs, start, end, rule, children));
        while (results.hasNext()) {
            void var10_14;
            Derivation derivation = (Derivation)results.next();
            if (FloatingParser.opts.betaReduce) {
                Derivation derivation2 = derivation.betaReduction();
            }
            var10_14.canonicalUtterance = canonicalUtterance;
            if (FloatingParser.opts.executeAllDerivations && !(var10_14.type instanceof FuncSemType)) {
                var10_14.ensureExecuted(this.parser.executor, this.ex.context);
            }
            if (this.pruner.isPruned((Derivation)var10_14)) continue;
            this.addToChart(this.cell(rule.lhs, start, end, depth), (Derivation)var10_14);
            if (depth != -1) continue;
            this.addToChart(this.floatingCell(rule.lhs, 0), (Derivation)var10_14);
        }
    }

    private boolean applyAnchoredRule(Rule rule, int start, int end, Derivation child1, Derivation child2, String canonicalUtterance) {
        return this.applyRule(rule, start, end, -1, child1, child2, canonicalUtterance);
    }

    private boolean applyFloatingRule(Rule rule, int depth, Derivation child1, Derivation child2, String canonicalUtterance) {
        return this.applyRule(rule, -1, -1, depth, child1, child2, canonicalUtterance);
    }

    private List<Derivation> getDerivations(Object cell) {
        List<Derivation> derivations = this.chart.get(cell);
        if (derivations == null) {
            return Derivation.emptyList;
        }
        return derivations;
    }

    private Collection<ChildDerivationsGroup> getFilteredDerivations(Rule rule, Object cell1, Object cell2) {
        List<Derivation> derivations2;
        List<Derivation> derivations1 = this.getDerivations(cell1);
        List<Derivation> list = derivations2 = cell2 == null ? null : this.getDerivations(cell2);
        if (!FloatingParser.opts.filterChildDerivations) {
            return Collections.singleton(new ChildDerivationsGroup(derivations1, derivations2));
        }
        if (rule.getSem().supportFilteringOnTypeData()) {
            return rule.getSem().getFilteredDerivations(derivations1, derivations2);
        }
        return Collections.singleton(new ChildDerivationsGroup(derivations1, derivations2));
    }

    private Collection<ChildDerivationsGroup> getFilteredDerivations(Rule rule, Object cell) {
        return this.getFilteredDerivations(rule, cell, null);
    }

    private void buildAnchored(int start, int end) {
        StopWatch stopWatch;
        for (Rule rule : this.parser.grammar.rules) {
            boolean match;
            if (!rule.isAnchored() || rule.rhs.size() != 1 || rule.isCatUnary()) continue;
            boolean bl = match = end - start == 1 && this.ex.token(start).equals(rule.rhs.get(0));
            if (!match) continue;
            stopWatch = new StopWatch().start();
            this.applyAnchoredRule(rule, start, end, null, null, rule.rhs.get(0));
            this.ruleTime.put(rule, this.ruleTime.getOrDefault(rule, 0L) + stopWatch.stop().ms);
        }
        for (int mid = start + 1; mid < end; ++mid) {
            for (Rule rule : this.parser.grammar.rules) {
                List<Derivation> derivations;
                boolean match2;
                if (!rule.isAnchored() || rule.rhs.size() != 2) continue;
                stopWatch = new StopWatch().start();
                String rhs1 = rule.rhs.get(0);
                String rhs2 = rule.rhs.get(1);
                boolean match1 = mid - start == 1 && this.ex.token(start).equals(rhs1);
                boolean bl = match2 = end - mid == 1 && this.ex.token(mid).equals(rhs2);
                if (!Rule.isCat(rhs1) && Rule.isCat(rhs2)) {
                    if (match1) {
                        derivations = this.getDerivations(this.anchoredCell(rhs2, mid, end));
                        for (Derivation deriv : derivations) {
                            this.applyAnchoredRule(rule, start, end, deriv, null, rhs1 + " " + deriv.canonicalUtterance);
                        }
                    }
                } else if (Rule.isCat(rhs1) && !Rule.isCat(rhs2)) {
                    if (match2) {
                        derivations = this.getDerivations(this.anchoredCell(rhs1, start, mid));
                        for (Derivation deriv : derivations) {
                            this.applyAnchoredRule(rule, start, end, deriv, null, deriv.canonicalUtterance + " " + rhs2);
                        }
                    }
                } else if (!Rule.isCat(rhs1) && !Rule.isCat(rhs2)) {
                    if (match1 && match2) {
                        this.applyAnchoredRule(rule, start, end, null, null, rhs1 + " " + rhs2);
                    }
                } else {
                    List<Derivation> derivations1 = this.getDerivations(this.anchoredCell(rhs1, start, mid));
                    List<Derivation> derivations2 = this.getDerivations(this.anchoredCell(rhs2, mid, end));
                    for (Derivation deriv1 : derivations1) {
                        for (Derivation deriv2 : derivations2) {
                            this.applyAnchoredRule(rule, start, end, deriv1, deriv2, deriv1.canonicalUtterance + " " + deriv2.canonicalUtterance);
                        }
                    }
                }
                this.ruleTime.put(rule, this.ruleTime.getOrDefault(rule, 0L) + stopWatch.stop().ms);
            }
        }
        for (Rule rule : this.parser.catUnaryRules) {
            if (!rule.isAnchored()) continue;
            StopWatch stopWatch2 = new StopWatch().start();
            List<Derivation> derivations = this.getDerivations(this.anchoredCell(rule.rhs.get(0), start, end));
            for (Derivation deriv : derivations) {
                this.applyAnchoredRule(rule, start, end, deriv, null, deriv.canonicalUtterance);
            }
            this.ruleTime.put(rule, this.ruleTime.getOrDefault(rule, 0L) + stopWatch2.stop().ms);
        }
    }

    private void buildFloating(int depth) {
        StopWatch stopWatch;
        if (depth == (FloatingParser.opts.initialFloatingHasZeroDepth ? 0 : 1)) {
            for (Rule rule : this.parser.grammar.rules) {
                if (this.timeout && !this.isRootRule(rule) || !rule.isFloating() || rule.rhs.size() != 1 || rule.isCatUnary()) continue;
                stopWatch = new StopWatch().start();
                this.applyFloatingRule(rule, depth, null, null, rule.rhs.get(0));
                this.ruleTime.put(rule, this.ruleTime.getOrDefault(rule, 0L) + stopWatch.stop().ms);
            }
        }
        for (Rule rule : this.parser.grammar.rules) {
            block21: {
                if (this.timeout && !this.isRootRule(rule) || !rule.isFloating() || rule.rhs.size() != 2 || this.catSizeBound.getBound(rule.lhs) < depth) continue;
                stopWatch = new StopWatch().start();
                String rhs1 = rule.rhs.get(0);
                String rhs2 = rule.rhs.get(1);
                if (!Rule.isCat(rhs1) || !Rule.isCat(rhs2)) {
                    throw new RuntimeException("Floating rules with > 1 arguments cannot have tokens on the RHS: " + rule);
                }
                if (FloatingParser.opts.useSizeInsteadOfDepth) {
                    for (int depth1 = 0; depth1 < depth; ++depth1) {
                        int depth2 = depth - 1 - depth1;
                        for (ChildDerivationsGroup group : this.getFilteredDerivations(rule, this.floatingCell(rhs1, depth1), this.floatingCell(rhs2, depth2))) {
                            for (Derivation deriv1 : group.derivations1) {
                                for (Derivation deriv2 : group.derivations2) {
                                    if (this.applyFloatingRule(rule, depth, deriv1, deriv2, deriv1.canonicalUtterance + " " + deriv2.canonicalUtterance)) continue;
                                    break block21;
                                }
                            }
                        }
                    }
                } else {
                    int subDepth;
                    block6: for (subDepth = 0; subDepth < depth; ++subDepth) {
                        for (ChildDerivationsGroup group : this.getFilteredDerivations(rule, this.floatingCell(rhs1, depth - 1), this.floatingCell(rhs2, subDepth))) {
                            for (Derivation deriv1 : group.derivations1) {
                                for (Derivation deriv2 : group.derivations2) {
                                    if (this.applyFloatingRule(rule, depth, deriv1, deriv2, deriv1.canonicalUtterance + " " + deriv2.canonicalUtterance)) continue;
                                    break block6;
                                }
                            }
                        }
                    }
                    for (subDepth = 0; subDepth < depth - 1; ++subDepth) {
                        for (ChildDerivationsGroup group : this.getFilteredDerivations(rule, this.floatingCell(rhs1, subDepth), this.floatingCell(rhs2, depth - 1))) {
                            for (Derivation deriv1 : group.derivations1) {
                                for (Derivation deriv2 : group.derivations2) {
                                    if (this.applyFloatingRule(rule, depth, deriv1, deriv2, deriv1.canonicalUtterance + " " + deriv2.canonicalUtterance)) continue;
                                    break block21;
                                }
                            }
                        }
                    }
                }
            }
            this.ruleTime.put(rule, this.ruleTime.getOrDefault(rule, 0L) + stopWatch.stop().ms);
        }
        for (Rule rule : this.parser.catUnaryRules) {
            if (this.timeout && !this.isRootRule(rule) || !rule.isFloating() || this.catSizeBound.getBound(rule.lhs) < depth) continue;
            stopWatch = new StopWatch().start();
            block15: for (ChildDerivationsGroup group : this.getFilteredDerivations(rule, this.floatingCell(rule.rhs.get(0), depth - 1))) {
                for (Derivation deriv : group.derivations1) {
                    if (this.applyFloatingRule(rule, depth, deriv, null, deriv.canonicalUtterance)) continue;
                    break block15;
                }
            }
            this.ruleTime.put(rule, this.ruleTime.getOrDefault(rule, 0L) + stopWatch.stop().ms);
        }
    }

    void addToDerivations(Object cell, List<Derivation> derivations) {
        List<Derivation> myDerivations = this.chart.get(cell);
        if (myDerivations != null) {
            derivations.addAll(myDerivations);
        }
    }

    @Override
    public void infer() {
        LogInfo.begin_track_printAll((String)"FloatingParser.infer()", (Object[])new Object[0]);
        this.ruleTime = new HashMap<Rule, Long>();
        for (Derivation derivation : this.gatherTokenAndPhraseDerivations()) {
            this.addToChart(this.anchoredCell(derivation.cat, derivation.start, derivation.end), derivation);
            this.addToChart(this.floatingCell(derivation.cat, 0), derivation);
        }
        final HashSet<String> categories = new HashSet<String>();
        for (Rule rule : this.parser.grammar.rules) {
            categories.add(rule.lhs);
        }
        if (Parser.opts.verbose >= 1) {
            LogInfo.begin_track_printAll((String)"Anchored", (Object[])new Object[0]);
        }
        int n = this.ex.numTokens();
        for (int len = 1; len <= n; ++len) {
            int i = 0;
            while (i + len <= n) {
                this.buildAnchored(i, i + len);
                for (String cat : categories) {
                    String cell = this.anchoredCell(cat, i, i + len).toString();
                    this.pruneCell(cell, this.chart.get(cell));
                }
                ++i;
            }
        }
        if (Parser.opts.verbose >= 1) {
            LogInfo.end_track();
        }
        this.timeout = false;
        Thread parsingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int depth;
                int n = depth = FloatingParser.opts.initialFloatingHasZeroDepth ? 0 : 1;
                while (depth <= FloatingParser.opts.maxDepth) {
                    if (Parser.opts.verbose >= 1) {
                        LogInfo.begin_track_printAll((String)"%s = %d", (Object[])new Object[]{FloatingParser.opts.useSizeInsteadOfDepth ? "SIZE" : "DEPTH", depth});
                    }
                    FloatingParserState.this.buildFloating(depth);
                    for (String cat : categories) {
                        String cell = FloatingParserState.this.floatingCell(cat, depth).toString();
                        FloatingParserState.this.pruneCell(cell, (List)FloatingParserState.this.chart.get(cell));
                    }
                    if (Parser.opts.verbose >= 1) {
                        LogInfo.end_track();
                    }
                    ++depth;
                }
            }
        });
        parsingThread.start();
        try {
            parsingThread.join(FloatingParser.opts.maxFloatingParsingTime * 1000);
            if (parsingThread.isAlive()) {
                LogInfo.warnings((String)"Parsing time exceeded %d seconds. Will now interrupt ...", (Object[])new Object[]{FloatingParser.opts.maxFloatingParsingTime});
                this.timeout = true;
                parsingThread.interrupt();
                parsingThread.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            LogInfo.fails((String)"DPParser error: %s", (Object[])new Object[]{e});
        }
        this.evaluation.add("timeout", this.timeout);
        if (FloatingParser.opts.summarizeRuleTime) {
            this.summarizeRuleTime();
        }
        this.addToDerivations(this.anchoredCell("$ROOT", 0, n), this.predDerivations);
        for (int depth = 0; depth <= FloatingParser.opts.maxDepth; ++depth) {
            this.addToDerivations(this.floatingCell("$ROOT", depth), this.predDerivations);
        }
        this.ensureExecuted();
        if (this.computeExpectedCounts) {
            this.expectedCounts = new HashMap();
            ParserState.computeExpectedCounts(this.predDerivations, this.expectedCounts);
        }
        if (Parser.opts.verbose >= 2) {
            LogInfo.begin_track_printAll((String)"Summary of Example %s", (Object[])new Object[]{this.ex.getUtterance()});
            for (Derivation deriv : this.predDerivations) {
                LogInfo.logs((String)"Generated: canonicalUtterance=%s, value=%s", (Object[])new Object[]{deriv.canonicalUtterance, deriv.value});
            }
            LogInfo.end_track();
        }
        if (FloatingParser.opts.printPredictedUtterances) {
            PrintWriter writer = IOUtils.openOutAppendEasy((String)Execution.getFile((String)"canonical_utterances"));
            PrintWriter fWriter = IOUtils.openOutAppendEasy((String)Execution.getFile((String)"utterances_formula.tsv"));
            Derivation.sortByScore(this.predDerivations);
            for (Derivation deriv : this.predDerivations) {
                if (!(deriv.score > -10.0)) continue;
                writer.println(String.format("%s\t%s", deriv.canonicalUtterance, deriv.score));
                fWriter.println(String.format("%s\t%s", deriv.canonicalUtterance, deriv.formula.toString()));
            }
            writer.close();
            fWriter.close();
        }
        LogInfo.end_track();
    }

    @Override
    protected void setEvaluation() {
        super.setEvaluation();
        this.evaluation.add("numCells", (double)this.chart.size());
    }

    private void visualizeAnchoredChart(Set<String> categories) {
        for (String cat : categories) {
            for (int len = 1; len <= this.numTokens; ++len) {
                int i = 0;
                while (i + len <= this.numTokens) {
                    List<Derivation> derivations = this.getDerivations(this.anchoredCell(cat, i, i + len));
                    for (Derivation deriv : derivations) {
                        LogInfo.logs((String)"ParserState.visualize: %s(%s:%s): %s", (Object[])new Object[]{cat, i, i + len, deriv});
                    }
                    ++i;
                }
            }
        }
    }

    private void summarizeRuleTime() {
        ArrayList<Map.Entry<Rule, Long>> entries = new ArrayList<Map.Entry<Rule, Long>>(this.ruleTime.entrySet());
        entries.sort((Comparator<Map.Entry<Rule, Long>>)new ValueComparator(true));
        LogInfo.begin_track_printAll((String)"Rule time", (Object[])new Object[0]);
        for (Map.Entry entry : entries) {
            LogInfo.logs((String)"%9d : %s", (Object[])new Object[]{entry.getValue(), entry.getKey()});
        }
        LogInfo.end_track();
    }
}

