/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import java.util.ArrayList;
import java.util.List;

public final class FloatingRuleUtils {
    private FloatingRuleUtils() {
    }

    public static List<Derivation> getDerivationAnchors(Derivation deriv) {
        ArrayList<Derivation> anchors = new ArrayList<Derivation>();
        if (deriv.rule.isAnchored()) {
            anchors.add(deriv);
        } else if (deriv.children != null && deriv.children.size() != 0) {
            for (Derivation child : deriv.children) {
                anchors.addAll(FloatingRuleUtils.getDerivationAnchors(child));
            }
        }
        return anchors;
    }

    public static boolean derivationAnchorsOverlap(Derivation a, Derivation b) {
        boolean[] aAnchors = a.getAnchoredTokens();
        boolean[] bAnchors = b.getAnchoredTokens();
        for (int i = 0; i < aAnchors.length && i < bAnchors.length; ++i) {
            if (!aAnchors[i] || !bAnchors[i]) continue;
            return true;
        }
        return false;
    }

    public static int maxNumAnchorOverlaps(Derivation a, Derivation b) {
        int[] aAnchors = a.getNumAnchors();
        int[] bAnchors = b.getNumAnchors();
        int n = Math.max(aAnchors.length, bAnchors.length);
        int maxAnchors = 0;
        for (int i = 0; i < n; ++i) {
            maxAnchors = Math.max(maxAnchors, (i < aAnchors.length ? aAnchors[i] : 0) + (i < bAnchors.length ? bAnchors[i] : 0));
        }
        return maxAnchors;
    }
}

