/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Function;
import edu.stanford.nlp.sempre.Formulas;
import edu.stanford.nlp.sempre.PrimitiveFormula;
import fig.basic.LispTree;
import java.util.List;

public abstract class Formula {
    private int hashCode = -1;
    public static Formula nullFormula = new PrimitiveFormula(){

        @Override
        public LispTree toLispTree() {
            return (LispTree)LispTree.proto.newLeaf("null");
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }

        @Override
        public int computeHashCode() {
            return 0;
        }
    };

    public abstract LispTree toLispTree();

    public abstract void forEach(Function<Formula, Boolean> var1);

    public abstract Formula map(Function<Formula, Formula> var1);

    public abstract List<Formula> mapToList(Function<Formula, List<Formula>> var1, boolean var2);

    @JsonValue
    public String toString() {
        return this.toLispTree().toString();
    }

    @JsonCreator
    public static Formula fromString(String str) {
        return Formulas.fromLispTree((LispTree)LispTree.proto.parseFromString(str));
    }

    public abstract boolean equals(Object var1);

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.computeHashCode();
        }
        return this.hashCode;
    }

    public abstract int computeHashCode();
}

