/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import edu.stanford.nlp.sempre.ActionFormula;
import edu.stanford.nlp.sempre.AggregateFormula;
import edu.stanford.nlp.sempre.ArithmeticFormula;
import edu.stanford.nlp.sempre.CallFormula;
import edu.stanford.nlp.sempre.CanonicalNames;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.JoinFormula;
import edu.stanford.nlp.sempre.LambdaFormula;
import edu.stanford.nlp.sempre.MarkFormula;
import edu.stanford.nlp.sempre.MergeFormula;
import edu.stanford.nlp.sempre.NameValue;
import edu.stanford.nlp.sempre.NotFormula;
import edu.stanford.nlp.sempre.NumberValue;
import edu.stanford.nlp.sempre.PrimitiveFormula;
import edu.stanford.nlp.sempre.ReverseFormula;
import edu.stanford.nlp.sempre.StringValue;
import edu.stanford.nlp.sempre.SuperlativeFormula;
import edu.stanford.nlp.sempre.Value;
import edu.stanford.nlp.sempre.ValueFormula;
import edu.stanford.nlp.sempre.Values;
import edu.stanford.nlp.sempre.VariableFormula;
import fig.basic.LispTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Formulas {
    public static Formula fromLispTree(LispTree tree) {
        Enum mode;
        if (tree.isLeaf()) {
            return new ValueFormula<NameValue>(new NameValue(tree.value, null));
        }
        Value value = Values.fromLispTreeOrNull(tree);
        if (value != null) {
            return new ValueFormula<Value>(value);
        }
        String func = ((LispTree)tree.child((int)0)).value;
        if (func != null) {
            if (func.equals("var")) {
                return new VariableFormula(((LispTree)tree.child((int)1)).value);
            }
            if (func.equals("lambda")) {
                return new LambdaFormula(((LispTree)tree.child((int)1)).value, Formulas.fromLispTree((LispTree)tree.child(2)));
            }
            if (func.equals("mark")) {
                return new MarkFormula(((LispTree)tree.child((int)1)).value, Formulas.fromLispTree((LispTree)tree.child(2)));
            }
            if (func.equals("not")) {
                return new NotFormula(Formulas.fromLispTree((LispTree)tree.child(1)));
            }
            if (func.equals("reverse")) {
                return new ReverseFormula(Formulas.fromLispTree((LispTree)tree.child(1)));
            }
            if (func.equals("call")) {
                Formula callFunc = Formulas.fromLispTree((LispTree)tree.child(1));
                ArrayList args = Lists.newArrayList();
                for (int i = 2; i < tree.children.size(); ++i) {
                    args.add(Formulas.fromLispTree((LispTree)tree.child(i)));
                }
                return new CallFormula(callFunc, (List<Formula>)args);
            }
        }
        if ((mode = MergeFormula.parseMode(func)) != null) {
            return new MergeFormula((MergeFormula.Mode)mode, Formulas.fromLispTree((LispTree)tree.child(1)), Formulas.fromLispTree((LispTree)tree.child(2)));
        }
        mode = AggregateFormula.parseMode(func);
        if (mode != null) {
            return new AggregateFormula((AggregateFormula.Mode)mode, Formulas.fromLispTree((LispTree)tree.child(1)));
        }
        mode = SuperlativeFormula.parseMode(func);
        if (mode != null) {
            Formula rank = Formulas.parseIntToFormula((LispTree)tree.child(1));
            Formula count = Formulas.parseIntToFormula((LispTree)tree.child(2));
            return new SuperlativeFormula((SuperlativeFormula.Mode)mode, rank, count, Formulas.fromLispTree((LispTree)tree.child(3)), Formulas.fromLispTree((LispTree)tree.child(4)));
        }
        mode = ArithmeticFormula.parseMode(func);
        if (mode != null) {
            return new ArithmeticFormula((ArithmeticFormula.Mode)mode, Formulas.fromLispTree((LispTree)tree.child(1)), Formulas.fromLispTree((LispTree)tree.child(2)));
        }
        mode = ActionFormula.parseMode(func);
        if (mode != null) {
            ArrayList args = Lists.newArrayList();
            for (int i = 1; i < tree.children.size(); ++i) {
                args.add(Formulas.fromLispTree((LispTree)tree.child(i)));
            }
            return new ActionFormula((ActionFormula.Mode)mode, args);
        }
        if (tree.children.size() != 2) {
            throw new RuntimeException("Invalid number of arguments for join (want 2): " + tree);
        }
        return new JoinFormula(Formulas.fromLispTree((LispTree)tree.child(0)), Formulas.fromLispTree((LispTree)tree.child(1)));
    }

    private static Formula parseIntToFormula(LispTree tree) {
        try {
            int i = Integer.parseInt(tree.value);
            double d = i;
            NumberValue value = new NumberValue(d);
            return new ValueFormula<NumberValue>(value);
        }
        catch (NumberFormatException e) {
            Formula formula = Formulas.fromLispTree(tree);
            if (!(formula instanceof PrimitiveFormula)) {
                throw new RuntimeException("Rank and count of argmax must be variables or numbers");
            }
            return formula;
        }
    }

    public static Formula substituteVar(Formula formula, final String var, final Formula replaceFormula) {
        return formula.map(new Function<Formula, Formula>(){

            public Formula apply(Formula formula) {
                if (formula instanceof VariableFormula) {
                    String name = ((VariableFormula)formula).name;
                    return var.equals(name) ? replaceFormula : formula;
                }
                if (formula instanceof LambdaFormula && ((LambdaFormula)formula).var.equals(var)) {
                    return formula;
                }
                return null;
            }
        });
    }

    public static Formula substituteFormula(Formula formula, final Formula searchFormula, final Formula replaceFormula) {
        return formula.map(new Function<Formula, Formula>(){

            public Formula apply(Formula formula) {
                if (formula.equals(searchFormula)) {
                    return replaceFormula;
                }
                return null;
            }
        });
    }

    public static Formula lambdaApply(LambdaFormula func, Formula arg) {
        return Formulas.substituteVar(func.body, func.var, arg);
    }

    public static Formula betaReduction(Formula formula) {
        return formula.map(new Function<Formula, Formula>(){

            public Formula apply(Formula formula) {
                if (formula instanceof JoinFormula) {
                    Formula relation = Formulas.betaReduction(((JoinFormula)formula).relation);
                    Formula child = ((JoinFormula)formula).child;
                    if (relation instanceof LambdaFormula) {
                        return Formulas.betaReduction(Formulas.lambdaApply((LambdaFormula)relation, child));
                    }
                }
                return null;
            }
        });
    }

    public static boolean containsFreeVar(Formula formula, VariableFormula var) {
        if (formula instanceof PrimitiveFormula) {
            return formula.equals(var);
        }
        if (formula instanceof MergeFormula) {
            MergeFormula merge = (MergeFormula)formula;
            return Formulas.containsFreeVar(merge.child1, var) || Formulas.containsFreeVar(merge.child2, var);
        }
        if (formula instanceof JoinFormula) {
            JoinFormula join = (JoinFormula)formula;
            return Formulas.containsFreeVar(join.relation, var) || Formulas.containsFreeVar(join.child, var);
        }
        if (formula instanceof LambdaFormula) {
            LambdaFormula lambda = (LambdaFormula)formula;
            if (lambda.var.equals(var.name)) {
                return false;
            }
            return Formulas.containsFreeVar(lambda.body, var);
        }
        if (formula instanceof MarkFormula) {
            MarkFormula mark = (MarkFormula)formula;
            return Formulas.containsFreeVar(mark.body, var);
        }
        if (formula instanceof ReverseFormula) {
            return Formulas.containsFreeVar(((ReverseFormula)formula).child, var);
        }
        if (formula instanceof AggregateFormula) {
            return Formulas.containsFreeVar(((AggregateFormula)formula).child, var);
        }
        if (formula instanceof ArithmeticFormula) {
            return Formulas.containsFreeVar(((ArithmeticFormula)formula).child1, var) || Formulas.containsFreeVar(((ArithmeticFormula)formula).child2, var);
        }
        if (formula instanceof SuperlativeFormula) {
            SuperlativeFormula superlative = (SuperlativeFormula)formula;
            return Formulas.containsFreeVar(superlative.rank, var) || Formulas.containsFreeVar(superlative.count, var) || Formulas.containsFreeVar(superlative.head, var) || Formulas.containsFreeVar(superlative.relation, var);
        }
        if (formula instanceof NotFormula) {
            NotFormula notForm = (NotFormula)formula;
            return Formulas.containsFreeVar(notForm.child, var);
        }
        throw new RuntimeException("Unhandled: " + formula);
    }

    public static Set<String> extractAtomicFreebaseElements(Formula formula) {
        HashSet<String> res = new HashSet<String>();
        LispTree formulaTree = formula.toLispTree();
        Formulas.extractAtomicFreebaseElements(formulaTree, res);
        return res;
    }

    private static void extractAtomicFreebaseElements(LispTree formulaTree, Set<String> res) {
        block3: {
            block1: {
                block2: {
                    if (!formulaTree.isLeaf()) break block1;
                    if (!formulaTree.value.startsWith("fb:")) break block2;
                    res.add(formulaTree.value);
                    break block3;
                }
                if (!formulaTree.value.startsWith("!fb:")) break block3;
                res.add(formulaTree.value.substring(1));
                break block3;
            }
            for (LispTree child : formulaTree.children) {
                Formulas.extractAtomicFreebaseElements(child, res);
            }
        }
    }

    public static boolean isCountFormula(Formula formula) {
        Formula l;
        Formula relation;
        if (formula instanceof AggregateFormula) {
            return ((AggregateFormula)formula).mode == AggregateFormula.Mode.count;
        }
        if (formula instanceof JoinFormula && (relation = ((JoinFormula)formula).relation) instanceof LambdaFormula && (l = ((LambdaFormula)relation).body) instanceof AggregateFormula) {
            return ((AggregateFormula)l).mode == AggregateFormula.Mode.count;
        }
        return false;
    }

    public static String getString(Formula formula) {
        if (formula instanceof ValueFormula) {
            Object value = ((ValueFormula)formula).value;
            if (value instanceof StringValue) {
                return ((StringValue)value).value;
            }
            if (value instanceof NameValue) {
                return ((NameValue)value).id;
            }
            if (value instanceof NumberValue) {
                return ((NumberValue)value).value + "";
            }
        } else if (formula instanceof VariableFormula) {
            return ((VariableFormula)formula).name;
        }
        return null;
    }

    public static String getNameId(Formula formula) {
        Object value;
        if (formula instanceof ValueFormula && (value = ((ValueFormula)formula).value) instanceof NameValue) {
            return ((NameValue)value).id;
        }
        return null;
    }

    public static double getDouble(Formula formula) {
        Object value;
        if (formula instanceof ValueFormula && (value = ((ValueFormula)formula).value) instanceof NumberValue) {
            return ((NumberValue)value).value;
        }
        return Double.NaN;
    }

    public static int getInt(Formula formula) {
        return (int)Formulas.getDouble(formula);
    }

    public static String getBinaryId(Formula formula) {
        Object v;
        if (formula instanceof ReverseFormula) {
            String childId = Formulas.getBinaryId(((ReverseFormula)formula).child);
            if (childId == null) {
                return null;
            }
            return CanonicalNames.reverseProperty(childId);
        }
        if (formula instanceof ValueFormula && (v = ((ValueFormula)formula).value) instanceof NameValue) {
            return ((NameValue)v).id;
        }
        return null;
    }

    public static ValueFormula<NameValue> newNameFormula(String id) {
        return new ValueFormula<NameValue>(new NameValue(id));
    }

    public static Set<String> extractSubparts(Formula f) {
        HashSet<String> res = new HashSet<String>();
        Formulas.extractSubpartsRecursive(f, res);
        return res;
    }

    private static void extractSubpartsRecursive(Formula f, Set<String> res) {
        res.add(f.toString());
        if (f instanceof AggregateFormula) {
            AggregateFormula aggFormula = (AggregateFormula)f;
            Formulas.extractSubpartsRecursive(aggFormula, res);
        } else if (f instanceof CallFormula) {
            CallFormula callFormula = (CallFormula)f;
            Formulas.extractSubpartsRecursive(callFormula.func, res);
            for (Formula argFormula : callFormula.args) {
                Formulas.extractSubpartsRecursive(argFormula, res);
            }
        } else if (f instanceof JoinFormula) {
            JoinFormula joinFormula = (JoinFormula)f;
            Formulas.extractSubpartsRecursive(joinFormula.relation, res);
            Formulas.extractSubpartsRecursive(joinFormula.child, res);
        } else if (f instanceof LambdaFormula) {
            LambdaFormula lambdaFormula = (LambdaFormula)f;
            Formulas.extractSubpartsRecursive(lambdaFormula.body, res);
        } else if (f instanceof MarkFormula) {
            MarkFormula markFormula = (MarkFormula)f;
            Formulas.extractSubpartsRecursive(markFormula.body, res);
        } else if (f instanceof MergeFormula) {
            MergeFormula mergeFormula = (MergeFormula)f;
            Formulas.extractSubpartsRecursive(mergeFormula.child1, res);
            Formulas.extractSubpartsRecursive(mergeFormula.child2, res);
        } else if (f instanceof NotFormula) {
            NotFormula notFormula = (NotFormula)f;
            Formulas.extractSubpartsRecursive(notFormula.child, res);
        } else if (f instanceof ReverseFormula) {
            ReverseFormula revFormula = (ReverseFormula)f;
            Formulas.extractSubpartsRecursive(revFormula.child, res);
        } else if (f instanceof SuperlativeFormula) {
            SuperlativeFormula superlativeFormula = (SuperlativeFormula)f;
            Formulas.extractSubpartsRecursive(superlativeFormula.rank, res);
            Formulas.extractSubpartsRecursive(superlativeFormula.count, res);
            Formulas.extractSubpartsRecursive(superlativeFormula.head, res);
            Formulas.extractSubpartsRecursive(superlativeFormula.relation, res);
        }
    }

    public static Formula reverseFormula(Formula rawFormula) {
        if (rawFormula instanceof ValueFormula) {
            ValueFormula vf = (ValueFormula)rawFormula;
            return Formulas.reverseNameFormula(vf);
        }
        if (rawFormula instanceof LambdaFormula) {
            LambdaFormula formula = (LambdaFormula)rawFormula;
            if (Formulas.isChain(formula.body)) {
                return new LambdaFormula(formula.var, Formulas.reverseChain(formula.body, new VariableFormula(formula.var)));
            }
            return new ReverseFormula(formula);
        }
        return new ReverseFormula(rawFormula);
    }

    private static boolean isChain(Formula source) {
        if (source instanceof JoinFormula) {
            JoinFormula join = (JoinFormula)source;
            return Formulas.isChain(join.child);
        }
        return source instanceof VariableFormula;
    }

    private static Formula reverseChain(Formula source, Formula result) {
        if (source instanceof JoinFormula) {
            JoinFormula join = (JoinFormula)source;
            return Formulas.reverseChain(join.child, new JoinFormula(Formulas.reverseFormula(join.relation), result));
        }
        if (source instanceof VariableFormula) {
            return result;
        }
        throw new RuntimeException("Not handled: " + source);
    }

    private static ValueFormula<NameValue> reverseNameFormula(ValueFormula<NameValue> formula) {
        String id = ((NameValue)formula.value).id;
        return new ValueFormula<NameValue>(new NameValue(CanonicalNames.reverseProperty(id)));
    }

    public static Formula simplifyReverses(Formula formula) {
        return formula.map(new Function<Formula, Formula>(){

            public Formula apply(Formula formula) {
                if (formula instanceof ReverseFormula) {
                    return Formulas.reverseFormula(((ReverseFormula)formula).child);
                }
                return null;
            }
        });
    }
}

