/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.AtomicSemType;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.TopSemType;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;

public class FuncSemType
extends SemType {
    public final SemType argType;
    public final SemType retType;

    public FuncSemType(SemType argType, SemType retType) {
        if (argType == null) {
            throw new RuntimeException("Null argType");
        }
        if (retType == null) {
            throw new RuntimeException("Null retType");
        }
        this.argType = argType;
        this.retType = retType;
    }

    public FuncSemType(String argType, String retType) {
        this(new AtomicSemType(argType), new AtomicSemType(retType));
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public SemType meet(SemType that) {
        if (that instanceof TopSemType) {
            return this;
        }
        if (!(that instanceof FuncSemType)) {
            return SemType.bottomType;
        }
        FuncSemType thatFunc = (FuncSemType)that;
        SemType newArgType = this.argType.meet(thatFunc.argType);
        if (!newArgType.isValid()) {
            return SemType.bottomType;
        }
        SemType newRetType = this.retType.meet(thatFunc.retType);
        if (!newRetType.isValid()) {
            return SemType.bottomType;
        }
        return new FuncSemType(newArgType, newRetType);
    }

    @Override
    public SemType apply(SemType that) {
        if (this.argType.meet(that).isValid()) {
            return this.retType;
        }
        return SemType.bottomType;
    }

    @Override
    public FuncSemType reverse() {
        return new FuncSemType(this.retType, this.argType);
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("->");
        tree.addChild((AbstractLispTree)this.argType.toLispTree());
        tree.addChild((AbstractLispTree)this.retType.toLispTree());
        return tree;
    }
}

