/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.FeatureExtractor;
import edu.stanford.nlp.sempre.FeatureVector;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.FuzzyMatchable;
import edu.stanford.nlp.sempre.MultipleDerivationStream;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.TypeInference;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import fig.basic.Option;
import java.util.ArrayList;
import java.util.List;

public class FuzzyMatchFn
extends SemanticFn {
    public static Options opts = new Options();
    private FuzzyMatchFnMode mode;
    private boolean matchAny = false;

    @Override
    public void init(LispTree tree) {
        super.init(tree);
        for (int i = 1; i < tree.children.size(); ++i) {
            String value = ((LispTree)tree.child((int)i)).value;
            if ("unary".equals(value)) {
                this.mode = FuzzyMatchFnMode.UNARY;
                continue;
            }
            if ("binary".equals(value)) {
                this.mode = FuzzyMatchFnMode.BINARY;
                continue;
            }
            if ("entity".equals(value)) {
                this.mode = FuzzyMatchFnMode.ENTITY;
                continue;
            }
            if ("any".equals(value)) {
                this.matchAny = true;
                continue;
            }
            if ("before".equals(value)) {
                this.mode = FuzzyMatchFnMode.ORDER_BEFORE;
                continue;
            }
            if ("after".equals(value)) {
                this.mode = FuzzyMatchFnMode.ORDER_AFTER;
                continue;
            }
            if ("next".equals(value)) {
                this.mode = FuzzyMatchFnMode.ORDER_NEXT;
                continue;
            }
            if ("prev".equals(value)) {
                this.mode = FuzzyMatchFnMode.ORDER_PREV;
                continue;
            }
            if ("adjacent".equals(value)) {
                this.mode = FuzzyMatchFnMode.ORDER_ADJACENT;
                continue;
            }
            throw new RuntimeException("Invalid argument: " + value);
        }
    }

    @Override
    public DerivationStream call(Example ex, SemanticFn.Callable c) {
        return new LazyFuzzyMatchFnDerivs(ex, c, this.mode, this.matchAny);
    }

    public static class LazyFuzzyMatchFnDerivs
    extends MultipleDerivationStream {
        final Example ex;
        final FuzzyMatchable matchable;
        final SemanticFn.Callable c;
        final String query;
        final List<String> sentence;
        final FuzzyMatchFnMode mode;
        final boolean matchAny;
        int index = 0;
        List<Formula> formulas;

        public LazyFuzzyMatchFnDerivs(Example ex, SemanticFn.Callable c, FuzzyMatchFnMode mode, boolean matchAny) {
            this.ex = ex;
            this.matchable = ex.context != null && ex.context.graph != null && ex.context.graph instanceof FuzzyMatchable ? (FuzzyMatchable)((Object)ex.context.graph) : null;
            this.c = c;
            String string = this.query = matchAny || c.getChildren().isEmpty() ? null : c.childStringValue(0);
            this.sentence = c.getRule().rhs.size() == 1 && "$PHRASE".equals(c.getRule().rhs.get(0)) ? ex.getTokens() : (c.getRule().rhs.size() == 1 && "$LEMMA_PHRASE".equals(c.getRule().rhs.get(0)) ? ex.getLemmaTokens() : null);
            this.mode = mode;
            this.matchAny = matchAny;
            if (FuzzyMatchFn.opts.verbose >= 2) {
                LogInfo.logs((String)"FuzzyMatchFn[%s]%s.call: %s", (Object[])new Object[]{this.mode, this.matchAny ? "[matchAny]" : "", this.query});
            }
        }

        @Override
        public Derivation createDerivation() {
            if (this.matchable == null) {
                return null;
            }
            if (this.query == null && !this.matchAny) {
                return null;
            }
            if (this.formulas == null) {
                this.formulas = this.matchAny ? new ArrayList<Formula>(this.matchable.getAllFormulas(this.mode)) : (this.sentence != null ? new ArrayList<Formula>(this.matchable.getFuzzyMatchedFormulas(this.sentence, this.c.getStart(), this.c.getEnd(), this.mode)) : new ArrayList<Formula>(this.matchable.getFuzzyMatchedFormulas(this.query, this.mode)));
            }
            if (this.index >= this.formulas.size()) {
                return null;
            }
            Formula formula = this.formulas.get(this.index++);
            SemType type = TypeInference.inferType(formula);
            FeatureVector features = new FeatureVector();
            if (FeatureExtractor.containsDomain("fuzzyMatch")) {
                features.add("fuzzyMatch", "mode=" + (Object)((Object)this.mode));
                if (this.matchAny) {
                    features.add("fuzzyMatch", "mode=" + (Object)((Object)this.mode) + "_any");
                }
            }
            return new Derivation.Builder().withCallable(this.c).formula(formula).type(type).localFeatureVector(features).createDerivation();
        }
    }

    public static enum FuzzyMatchFnMode {
        UNARY,
        BINARY,
        ENTITY,
        ORDER_BEFORE,
        ORDER_AFTER,
        ORDER_NEXT,
        ORDER_PREV,
        ORDER_ADJACENT;

    }

    public static class Options {
        @Option
        public int verbose = 0;
    }
}

