/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.stanford.nlp.sempre.ConstantFn;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.JoinFn;
import edu.stanford.nlp.sempre.Rule;
import edu.stanford.nlp.sempre.SelectFn;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SempreUtils;
import fig.basic.AbstractLispTree;
import fig.basic.IOUtils;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Utils;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Grammar {
    public static Options opts = new Options();
    ArrayList<Rule> rules = new ArrayList();
    Map<String, LispTree> macros = new HashMap<String, LispTree>();
    Set<String> validTags = new TreeSet<String>();
    List<String> statements = new ArrayList<String>();
    public static final String INTERMEDIATE_PREFIX = "$Intermediate";
    private int freshCatIndex = 0;

    public List<Rule> getRules() {
        return this.rules;
    }

    public void read() {
        LogInfo.begin_track((String)"Grammar.read", (Object[])new Object[0]);
        this.read(Grammar.opts.inPaths);
        LogInfo.logs((String)"%s rules", (Object[])new Object[]{this.rules.size()});
        LogInfo.end_track();
    }

    public void read(String path) {
        this.read(Collections.singletonList(path));
    }

    public void read(List<String> paths) {
        for (String path : paths) {
            this.readOnePath(path, Sets.newHashSet(Grammar.opts.tags));
        }
        this.verifyValid();
    }

    private void verifyValid() {
        HashSet<String> defined = new HashSet<String>();
        defined.add("$TOKEN");
        defined.add("$PHRASE");
        defined.add("$LEMMA_TOKEN");
        defined.add("$LEMMA_PHRASE");
        for (Rule rule : this.rules) {
            defined.add(rule.lhs);
        }
        for (Rule rule : this.rules) {
            for (String item : rule.rhs) {
                if (!Rule.isCat(item) || defined.contains(item)) continue;
                LogInfo.warnings((String)"Category not defined in the grammar: %s; used in rule: %s", (Object[])new Object[]{item, rule});
            }
        }
        LogInfo.logs((String)"Valid tags: %s", (Object[])new Object[]{this.validTags});
        LogInfo.logs((String)"Used tags: %s", (Object[])new Object[]{new TreeSet<String>(Grammar.opts.tags)});
        for (String tag : Grammar.opts.tags) {
            if (this.validTags.contains(tag)) continue;
            LogInfo.warnings((String)"Tag %s not defined in grammar", (Object[])new Object[]{tag});
        }
    }

    public void addStatement(String stmt, String contextPath, Set<String> tags) {
        this.statements.add(stmt);
        this.interpret(contextPath, (LispTree)LispTree.proto.parseFromString(stmt), Sets.newHashSet((Iterable)Iterables.concat(tags, Grammar.opts.tags)));
    }

    public void addStatement(String stmt, String contextPath) {
        Set<String> s = Collections.emptySet();
        this.addStatement(stmt, null, s);
    }

    public void addStatement(String stmt) {
        this.addStatement(stmt, null);
    }

    private static boolean isValidVar(String var) {
        return var.startsWith("@");
    }

    private static void checkIsValidVar(String var) {
        if (!Grammar.isValidVar("@")) {
            throw new RuntimeException("Invalid variable: '" + var + "' doesn't start with '@'");
        }
    }

    private static LispTree applyMacros(Map<String, LispTree> macros, LispTree tree) {
        if (tree.isLeaf()) {
            LispTree replacement = macros.get(tree.value);
            if (replacement != null) {
                return replacement;
            }
            if (Grammar.isValidVar(tree.value)) {
                throw new RuntimeException("Undefined macro: " + tree.value);
            }
            return tree;
        }
        LispTree newTree = (LispTree)LispTree.proto.newList();
        for (LispTree child : tree.children) {
            newTree.addChild((AbstractLispTree)Grammar.applyMacros(macros, child));
        }
        return newTree;
    }

    public LispTree applyMacros(LispTree tree) {
        return Grammar.applyMacros(this.macros, tree);
    }

    private void readOnePath(String path, Set<String> tags) {
        if (this.statements.size() > 0) {
            this.statements.add("");
        }
        this.statements.add("####### " + path);
        for (String line : IOUtils.readLinesHard((String)path)) {
            this.statements.add(line);
        }
        Iterator trees = LispTree.proto.parseFromFile(path);
        while (trees.hasNext()) {
            LispTree tree = (LispTree)trees.next();
            this.interpret(path, tree, tags);
            this.collectValidTags(tree);
        }
    }

    public void write() {
        String path = Execution.getFile((String)"grammar");
        if (path == null) {
            return;
        }
        PrintWriter out = IOUtils.openOutHard((String)path);
        for (String statement : this.statements) {
            out.println(statement);
        }
        out.close();
        out = IOUtils.openOutHard((String)Execution.getFile((String)"processed-grammar"));
        for (Rule rule : this.rules) {
            out.println(rule.toLispTree().toString());
        }
        out.close();
    }

    private void interpret(String path, LispTree tree, Set<String> tags) {
        block12: {
            if (tree.isLeaf()) {
                throw new RuntimeException("Expected list, got " + tree);
            }
            try {
                String command = ((LispTree)tree.child((int)0)).value;
                if ("rule".equals(command)) {
                    this.interpretRule(tree);
                    break block12;
                }
                if ("include".equals(command)) {
                    if (path == null) {
                        throw new RuntimeException("Grammar include statement given without context path");
                    }
                    for (int i = 1; i < tree.children.size(); ++i) {
                        this.readOnePath(new File(path).getParent() + "/" + ((LispTree)tree.child((int)i)).value, tags);
                    }
                    break block12;
                }
                if ("when".equals(command)) {
                    if (this.interpretBoolean((LispTree)tree.child(1), tags)) {
                        for (int i = 2; i < tree.children.size(); ++i) {
                            this.interpret(path, (LispTree)tree.child(i), tags);
                        }
                    }
                    break block12;
                }
                if ("def".equals(command)) {
                    this.interpretMacroDef(tree);
                    break block12;
                }
                if ("for".equals(command)) {
                    this.interpretFor(path, tree, tags);
                    break block12;
                }
                throw new RuntimeException("Invalid command: " + command);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error on " + tree + ": " + e);
            }
        }
    }

    private boolean interpretBoolean(LispTree tree, Set<String> tags) {
        if (tree.isLeaf()) {
            return tags.contains(tree.value);
        }
        if ("not".equals(((LispTree)tree.child((int)0)).value)) {
            if (tree.children.size() != 2) {
                throw new RuntimeException("Too many arguments for not: " + tree);
            }
            return !this.interpretBoolean((LispTree)tree.child(1), tags);
        }
        if ("and".equals(((LispTree)tree.child((int)0)).value)) {
            for (int i = 1; i < tree.children.size(); ++i) {
                if (this.interpretBoolean((LispTree)tree.child(i), tags)) continue;
                return false;
            }
            return true;
        }
        if ("or".equals(((LispTree)tree.child((int)0)).value)) {
            for (int i = 1; i < tree.children.size(); ++i) {
                if (!this.interpretBoolean((LispTree)tree.child(i), tags)) continue;
                return true;
            }
            return false;
        }
        throw new RuntimeException("Expected a single tag, but got: " + tree);
    }

    public void interpretMacroDef(LispTree tree) {
        if (tree.children.size() != 3 || !((LispTree)tree.child(1)).isLeaf()) {
            throw new RuntimeException("Invalid usage (def |name| |value|): " + tree);
        }
        String var = ((LispTree)tree.child((int)1)).value;
        Grammar.checkIsValidVar(var);
        this.macros.put(var, this.applyMacros((LispTree)tree.child(2)));
    }

    public void interpretFor(String path, LispTree tree, Set<String> tags) {
        if (tree.children.size() <= 3 || !((LispTree)tree.child(1)).isLeaf()) {
            throw new RuntimeException("Invalid usage (for |var| (|value| ... |value|) |statement| ...) " + tree);
        }
        String var = ((LispTree)tree.child((int)1)).value;
        Grammar.checkIsValidVar(var);
        List values = this.applyMacros((LispTree)((LispTree)tree.child((int)2))).children;
        LispTree old = this.macros.get(var);
        for (LispTree value : values) {
            this.macros.put(var, value);
            for (int j = 3; j < tree.children.size(); ++j) {
                this.interpret(path, (LispTree)tree.child(j), tags);
            }
        }
        if (old == null) {
            this.macros.remove(var);
        } else {
            this.macros.put(var, old);
        }
    }

    private static String checkCatName(String cat) {
        if (Grammar.isIntermediate(cat)) {
            LogInfo.warnings((String)"Category '%s' starts with '$Intermediate'; please avoid this unless you know what you are doing.", (Object[])new Object[0]);
        }
        return cat;
    }

    private void interpretRule(LispTree tree) {
        if (tree.children.size() < 4) {
            throw new RuntimeException("Invalid rule: " + tree);
        }
        if (!((LispTree)(tree = this.applyMacros(tree)).child(1)).isLeaf()) {
            throw new RuntimeException("Invalid LHS: " + tree.child(1));
        }
        String lhs = Grammar.checkCatName(((LispTree)tree.child((int)1)).value);
        ArrayList rhs = Lists.newArrayList();
        ArrayList<Boolean> isOptionals = new ArrayList<Boolean>();
        LispTree rhsTree = (LispTree)tree.child(2);
        if (rhsTree.isLeaf()) {
            throw new RuntimeException("RHS needs to be list, but got: " + rhsTree);
        }
        for (int i = 0; i < rhsTree.children.size(); ++i) {
            LispTree child = (LispTree)rhsTree.child(i);
            boolean isOptional = false;
            if (child.isLeaf()) {
                rhs.add(Grammar.checkCatName(child.value));
            } else {
                rhs.add(Grammar.checkCatName(((LispTree)child.child((int)0)).value));
                for (int j = 1; j < child.children.size(); ++j) {
                    if (!((LispTree)child.child((int)j)).value.equals("optional")) continue;
                    isOptional = true;
                }
            }
            isOptionals.add(isOptional);
        }
        SemanticFn sem = this.parseSemanticFn((LispTree)tree.child(3));
        Rule rule = new Rule(lhs, rhs, sem);
        for (int i = 4; i < tree.children.size(); ++i) {
            LispTree item = (LispTree)tree.child(i);
            if (!item.isLeaf() && item.children.size() != 2) {
                throw new RuntimeException("Invalid key-value pair: " + item);
            }
            try {
                rule.addInfo(((LispTree)item.child((int)0)).value, Double.parseDouble(((LispTree)item.child((int)1)).value));
                continue;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid key-value pair: " + item);
            }
        }
        this.addRule(rule, isOptionals);
    }

    public synchronized void addRule(Rule rule) {
        ArrayList<Boolean> isOptionals = new ArrayList<Boolean>();
        for (int i = 0; i < rule.rhs.size(); ++i) {
            isOptionals.add(false);
        }
        this.addRule(rule, isOptionals);
    }

    public synchronized void addRule(Rule rule, List<Boolean> isOptionals) {
        this.rules.addAll(this.binarizeRule(rule, isOptionals));
    }

    private void collectValidTags(LispTree tree) {
        if (tree.isLeaf()) {
            throw new RuntimeException("Expected list, got " + tree);
        }
        try {
            String command = ((LispTree)tree.child((int)0)).value;
            if ("when".equals(command)) {
                this.collectValidTagsBoolean((LispTree)tree.child(1));
                for (int i = 2; i < tree.children.size(); ++i) {
                    this.collectValidTags((LispTree)tree.child(i));
                }
            } else if ("for".equals(command)) {
                for (int i = 3; i < tree.children.size(); ++i) {
                    this.collectValidTags((LispTree)tree.child(i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error on " + tree + ": " + e);
        }
    }

    private void collectValidTagsBoolean(LispTree tree) {
        if (tree.isLeaf()) {
            this.validTags.add(tree.value);
            return;
        }
        String command = ((LispTree)tree.child((int)0)).value;
        if ("not".equals(command)) {
            this.collectValidTagsBoolean((LispTree)tree.child(1));
        } else if ("and".equals(command) || "or".equals(command)) {
            for (int i = 1; i < tree.children.size(); ++i) {
                this.collectValidTagsBoolean((LispTree)tree.child(i));
            }
        }
    }

    private String generateFreshCat() {
        ++this.freshCatIndex;
        return INTERMEDIATE_PREFIX + this.freshCatIndex;
    }

    public static boolean isIntermediate(String cat) {
        return cat.startsWith(INTERMEDIATE_PREFIX);
    }

    private List<Rule> binarizeRule(Rule rule, List<Boolean> isOptionals) {
        ArrayList<Rule> newRules = new ArrayList<Rule>();
        if (!Grammar.opts.binarizeRules) {
            if (isOptionals.contains(true)) {
                throw new RuntimeException("Can't have optionals if don't binarize: " + rule + " " + isOptionals);
            }
            newRules.add(rule);
            return newRules;
        }
        if (rule.sem instanceof JoinFn && ((JoinFn)rule.sem).getArg0Fn() != null) {
            int j;
            int i;
            for (i = 0; i < rule.rhs.size() && (!Rule.isCat(rule.rhs.get(i)) || isOptionals.get(i).booleanValue()); ++i) {
            }
            for (j = i + 1; j < rule.rhs.size() && (!Rule.isCat(rule.rhs.get(j)) || isOptionals.get(j).booleanValue()); ++j) {
            }
            if (j < rule.rhs.size()) {
                String intCat = this.generateFreshCat();
                ArrayList<String> rhs1 = new ArrayList<String>(rule.rhs.subList(0, i + 1));
                newRules.addAll(this.binarizeRule(new Rule(intCat, rhs1, rule.sem).setInfo(rule), isOptionals.subList(0, i + 1)));
                ArrayList<String> rhs2 = new ArrayList<String>();
                rhs2.add(intCat);
                rhs2.addAll(rule.rhs.subList(i + 1, rule.rhs.size()));
                JoinFn forwardBetaReduce = new JoinFn();
                ((SemanticFn)forwardBetaReduce).init((LispTree)LispTree.proto.parseFromString("(JoinFn forward betaReduce)"));
                newRules.addAll(this.binarizeRule(new Rule(rule.lhs, rhs2, forwardBetaReduce).setInfo(rule), isOptionals.subList(i, isOptionals.size())));
                return newRules;
            }
        }
        if (!isOptionals.contains(false)) {
            throw new RuntimeException("Can't have all RHS items be optional: " + rule + " " + isOptionals);
        }
        if (rule.rhs.size() <= 1) {
            newRules.add(rule);
            return newRules;
        }
        ArrayList<String> newRhs = new ArrayList<String>();
        ArrayList<Boolean> newIsOptional = new ArrayList<Boolean>();
        ArrayList<Boolean> isRequiredCat = new ArrayList<Boolean>();
        assert (rule.rhs.size() >= 2);
        boolean appliedRuleSem = false;
        for (int i = 0; i < rule.rhs.size(); ++i) {
            String lhs;
            newRhs.add(rule.rhs.get(i));
            newIsOptional.add(isOptionals.get(i));
            isRequiredCat.add(isOptionals.get(i) == false && Rule.isCat(rule.rhs.get(i)));
            if (newRhs.size() < 2) continue;
            if (((Boolean)isRequiredCat.get(0)).booleanValue() && ((Boolean)isRequiredCat.get(1)).booleanValue()) {
                appliedRuleSem = true;
            }
            boolean atEnd = i == rule.rhs.size() - 1;
            String string = lhs = atEnd && appliedRuleSem ? rule.lhs : this.generateFreshCat();
            assert (newRhs.size() == 2);
            boolean allCanBeOptional = false;
            for (int b0 = 0; b0 < 2; ++b0) {
                if (b0 == 0 && !((Boolean)newIsOptional.get(0)).booleanValue()) continue;
                for (int b1 = 0; b1 < 2; ++b1) {
                    if (b1 == 0 && !((Boolean)newIsOptional.get(1)).booleanValue()) continue;
                    ArrayList rhs = Lists.newArrayList();
                    if (b0 == 1) {
                        rhs.add((String)newRhs.get(0));
                    }
                    if (b1 == 1) {
                        rhs.add((String)newRhs.get(1));
                    }
                    SemanticFn sem = (Boolean)isRequiredCat.get(0) != false && (Boolean)isRequiredCat.get(1) != false ? rule.sem : (b0 == 1 && Rule.isCat((String)rhs.get(0)) && (Boolean)isRequiredCat.get(1) != false ? new SelectFn(1) : ((Boolean)isRequiredCat.get(0) != false || (Boolean)isRequiredCat.get(1) != false ? new SelectFn(0) : new ConstantFn(Formula.nullFormula)));
                    if (rhs.size() > 0) {
                        newRules.add(new Rule(lhs, rhs, sem).setInfo(rule));
                        continue;
                    }
                    allCanBeOptional = true;
                }
            }
            boolean req = (Boolean)isRequiredCat.get(0) != false || (Boolean)isRequiredCat.get(1) != false;
            newRhs.clear();
            newRhs.add(lhs);
            newIsOptional.clear();
            newIsOptional.add(allCanBeOptional);
            isRequiredCat.clear();
            isRequiredCat.add(req);
        }
        assert (newRhs.size() == 1);
        assert (!((Boolean)newIsOptional.get(0)).booleanValue());
        if (!appliedRuleSem) {
            newRules.add(new Rule(rule.lhs, Lists.newArrayList(newRhs), rule.sem).setInfo(rule));
        }
        return newRules;
    }

    private SemanticFn parseSemanticFn(LispTree tree) {
        SemanticFn fn;
        String name;
        if (tree.isLeaf()) {
            LispTree newTree = (LispTree)LispTree.proto.newList();
            newTree.addChild("ConstantFn");
            newTree.addChild(tree.value);
            tree = newTree;
        }
        if ((name = ((LispTree)tree.child((int)0)).value).equals("lambda")) {
            LispTree newTree = (LispTree)LispTree.proto.newList();
            if (Grammar.opts.useApplyFn == null) {
                newTree.addChild("JoinFn");
                newTree.addChild("betaReduce");
                newTree.addChild("forward");
                newTree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("arg0", (AbstractLispTree)tree)));
            } else {
                newTree.addChild(Grammar.opts.useApplyFn);
                newTree.addChild((AbstractLispTree)tree);
            }
            tree = newTree;
            name = ((LispTree)tree.child((int)0)).value;
        }
        if (name.equals("LexiconFn") || name.equals("BridgeFn")) {
            name = "freebase." + name;
        }
        if ((fn = (SemanticFn)Utils.newInstanceHard((String)SempreUtils.resolveClassName(name))) == null) {
            throw new RuntimeException("Invalid SemanticFn name: " + name);
        }
        fn.init(tree);
        return fn;
    }

    public static class Options {
        @Option
        public List<String> inPaths = new ArrayList<String>();
        @Option(gloss="Variables which are used to interpret the grammar file")
        public List<String> tags = new ArrayList<String>();
        @Option
        public boolean binarizeRules = true;
        @Option(gloss="Specifiy which ApplyFn to use: defaults to JoinFn when null")
        public String useApplyFn = null;
    }
}

