/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.stanford.nlp.sempre.BooleanValue;
import edu.stanford.nlp.sempre.CallFormula;
import edu.stanford.nlp.sempre.ContextValue;
import edu.stanford.nlp.sempre.ErrorValue;
import edu.stanford.nlp.sempre.Executor;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Formulas;
import edu.stanford.nlp.sempre.LambdaFormula;
import edu.stanford.nlp.sempre.ListValue;
import edu.stanford.nlp.sempre.NameValue;
import edu.stanford.nlp.sempre.NumberValue;
import edu.stanford.nlp.sempre.StringValue;
import edu.stanford.nlp.sempre.Value;
import edu.stanford.nlp.sempre.ValueFormula;
import fig.basic.MapUtils;
import fig.basic.Option;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class JavaExecutor
extends Executor {
    public static Options opts = new Options();
    private static JavaExecutor defaultExecutor = new JavaExecutor();
    private Map<String, String> shortcuts = Maps.newHashMap();
    private static final int INVALID_TYPE_COST = 1000;

    public JavaExecutor() {
        String className = BasicFunctions.class.getName();
        this.shortcuts.put("+", className + ".plus");
        this.shortcuts.put("-", className + ".minus");
        this.shortcuts.put("*", className + ".times");
        this.shortcuts.put("/", className + ".divide");
        this.shortcuts.put("%", className + ".mod");
        this.shortcuts.put("!", className + ".not");
        this.shortcuts.put("<", className + ".lessThan");
        this.shortcuts.put("<=", className + ".lessThanEq");
        this.shortcuts.put("==", className + ".equals");
        this.shortcuts.put(">", className + ".greaterThan");
        this.shortcuts.put(">=", className + ".greaterThanEq");
        this.shortcuts.put("if", className + ".ifThenElse");
        this.shortcuts.put("map", className + ".map");
        this.shortcuts.put("reduce", className + ".reduce");
        this.shortcuts.put("select", className + ".select");
        this.shortcuts.put("range", className + ".range");
    }

    @Override
    public Executor.Response execute(Formula formula, ContextValue context) {
        formula = Formulas.betaReduction(formula);
        try {
            return new Executor.Response(JavaExecutor.toValue(this.processFormula(formula, context)));
        }
        catch (Exception e) {
            if (JavaExecutor.opts.printStackTrace) {
                e.printStackTrace();
            }
            return new Executor.Response(ErrorValue.badJava(e.toString()));
        }
    }

    private Object processFormula(Formula formula, ContextValue context) {
        if (formula instanceof ValueFormula) {
            return JavaExecutor.toObject(((ValueFormula)formula).value);
        }
        if (formula instanceof CallFormula) {
            CallFormula call = (CallFormula)formula;
            Object func = this.processFormula(call.func, context);
            ArrayList args = Lists.newArrayList();
            for (Formula arg : call.args) {
                args.add(this.processFormula(arg, context));
            }
            if (!(func instanceof NameValue)) {
                throw new RuntimeException("Invalid func: " + call.func + " => " + func);
            }
            String id = ((NameValue)func).id;
            if (id.indexOf(JavaExecutor.opts.contextPrefix) != -1) {
                args.add(context);
                id = id.replace(JavaExecutor.opts.contextPrefix, "");
            }
            id = (String)MapUtils.get(this.shortcuts, (Object)id, (Object)id);
            if (!(Strings.isNullOrEmpty((String)JavaExecutor.opts.classPathPrefix) || id.startsWith(".") || id.startsWith(JavaExecutor.opts.classPathPrefix))) {
                id = JavaExecutor.opts.classPathPrefix + "." + id;
            }
            if (id.startsWith(".")) {
                return this.invoke(id.substring(1), args.get(0), args.subList(1, args.size()).toArray(new Object[0]));
            }
            return this.invoke(id, null, args.toArray(new Object[0]));
        }
        return formula;
    }

    private static Value toValue(Object obj) {
        if (obj instanceof Value) {
            return (Value)obj;
        }
        if (obj instanceof Boolean) {
            return new BooleanValue((Boolean)obj);
        }
        if (obj instanceof Integer) {
            return new NumberValue(((Integer)obj).intValue());
        }
        if (obj instanceof Double) {
            return new NumberValue((Double)obj);
        }
        if (obj instanceof String) {
            return new StringValue((String)obj);
        }
        if (obj instanceof List) {
            ArrayList list = Lists.newArrayList();
            for (Object elem : (List)obj) {
                list.add(JavaExecutor.toValue(elem));
            }
            return new ListValue(list);
        }
        throw new RuntimeException("Unhandled object: " + obj + " with class " + obj.getClass());
    }

    private static Object toObject(Value value) {
        if (value instanceof NumberValue && JavaExecutor.opts.convertNumberValues) {
            double x = ((NumberValue)value).value;
            if (x == (double)((int)x)) {
                return new Integer((int)x);
            }
            return new Double(x);
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).value;
        }
        if (value instanceof StringValue) {
            return ((StringValue)value).value;
        }
        if (value instanceof ListValue) {
            ArrayList list = Lists.newArrayList();
            for (Value elem : ((ListValue)value).values) {
                list.add(JavaExecutor.toObject(elem));
            }
            return list;
        }
        return value;
    }

    private Object invoke(String id, Object thisObj, Object[] args) {
        Method[] methods;
        Class<?> cls;
        String methodName;
        boolean isStatic;
        boolean bl = isStatic = thisObj == null;
        if (isStatic) {
            int i = id.lastIndexOf(46);
            if (i == -1) {
                throw new RuntimeException("Expected <class>.<method>, but got: " + id);
            }
            String className = id.substring(0, i);
            methodName = id.substring(i + 1);
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            methods = cls.getMethods();
        } else {
            cls = thisObj.getClass();
            methodName = id;
            methods = cls.getMethods();
        }
        ArrayList nameMatches = Lists.newArrayList();
        Method bestMethod = null;
        int bestCost = 1000;
        for (Method m : methods) {
            int cost;
            if (!m.getName().equals(methodName)) continue;
            m.setAccessible(true);
            nameMatches.add(m);
            if (isStatic != Modifier.isStatic(m.getModifiers()) || (cost = this.typeCastCost(m.getParameterTypes(), args)) >= bestCost) continue;
            bestCost = cost;
            bestMethod = m;
        }
        if (bestMethod != null) {
            try {
                return bestMethod.invoke(thisObj, args);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList types = Lists.newArrayList();
        for (Object arg : args) {
            types.add(arg.getClass().toString());
        }
        throw new RuntimeException("Method " + methodName + " not found in class " + cls + " with arguments " + Arrays.asList(args) + " having types " + types + "; candidates: " + nameMatches);
    }

    private int typeCastCost(Class[] types, Object[] args) {
        if (types.length != args.length) {
            return 1000;
        }
        int cost = 0;
        for (int i = 0; i < types.length && (cost += this.typeCastCost(types[i], args[i])) < 1000; ++i) {
        }
        return cost;
    }

    private int typeCastCost(Class<?> type, Object arg) {
        if (arg == null) {
            return !type.isPrimitive() ? 0 : 1000;
        }
        if (type.isInstance(arg)) {
            return 0;
        }
        if (type == Boolean.TYPE) {
            return arg instanceof Boolean ? 0 : 1000;
        }
        if (type == Integer.TYPE) {
            if (arg instanceof Integer) {
                return 0;
            }
            if (arg instanceof Long) {
                return 1;
            }
            return 1000;
        }
        if (type == Long.TYPE) {
            if (arg instanceof Integer) {
                return 1;
            }
            if (arg instanceof Long) {
                return 0;
            }
            return 1000;
        }
        if (type == Float.TYPE) {
            if (arg instanceof Integer) {
                return 1;
            }
            if (arg instanceof Long) {
                return 1;
            }
            if (arg instanceof Float) {
                return 0;
            }
            if (arg instanceof Double) {
                return 2;
            }
            return 1000;
        }
        if (type == Double.TYPE) {
            if (arg instanceof Integer) {
                return 1;
            }
            if (arg instanceof Long) {
                return 1;
            }
            if (arg instanceof Float) {
                return 1;
            }
            if (arg instanceof Double) {
                return 0;
            }
            return 1000;
        }
        return 1000;
    }

    public static class BasicFunctions {
        public static double plus(double x, double y) {
            return x + y;
        }

        public static int plus(int x, int y) {
            return x + y;
        }

        public static int minus(int x, int y) {
            return x - y;
        }

        public static double minus(double x, double y) {
            return x - y;
        }

        public static int times(int x, int y) {
            return x * y;
        }

        public static double times(double x, double y) {
            return x * y;
        }

        public static int divide(int x, int y) {
            return x / y;
        }

        public static double divide(double x, double y) {
            return x / y;
        }

        public static int mod(int x, int y) {
            return x % y;
        }

        public static boolean not(boolean x) {
            return !x;
        }

        public static boolean lessThan(double x, double y) {
            return x < y;
        }

        public static boolean lessThanEq(double x, double y) {
            return x <= y;
        }

        public static boolean equals(double x, double y) {
            return x == y;
        }

        public static boolean greaterThan(double x, double y) {
            return x > y;
        }

        public static boolean greaterThanEq(double x, double y) {
            return x >= y;
        }

        public static Object ifThenElse(boolean b, Object x, Object y) {
            return b ? x : y;
        }

        public static String plus(String a, String b) {
            return a + b;
        }

        public static String plus(String a, String b, String c) {
            return a + b + c;
        }

        public static String plus(String a, String b, String c, String d) {
            return a + b + c + d;
        }

        public static String plus(String a, String b, String c, String d, String e) {
            return a + b + c + d + e;
        }

        public static String plus(String a, String b, String c, String d, String e, String f) {
            return a + b + c + d + e + f;
        }

        public static String plus(String a, String b, String c, String d, String e, String f, String g) {
            return a + b + c + d + e + f + g;
        }

        private static String toString(Object x) {
            if (x instanceof String) {
                return (String)x;
            }
            if (x instanceof Value) {
                return x instanceof NameValue ? ((NameValue)x).id : ((StringValue)x).value;
            }
            return null;
        }

        public static List<Object> map(List<Object> list, LambdaFormula func) {
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object elem : list) {
                Object newElem = BasicFunctions.apply(func, elem);
                newList.add(newElem);
            }
            return newList;
        }

        public static Object reduce(List<Object> list, LambdaFormula func) {
            if (list.size() == 0) {
                return null;
            }
            Object x = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                x = BasicFunctions.apply(func, x, list.get(i));
            }
            return x;
        }

        public static List<Object> select(List<Object> list, LambdaFormula func) {
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object elem : list) {
                Object test = BasicFunctions.apply(func, elem);
                if (!((Boolean)test).booleanValue()) continue;
                newList.add(elem);
            }
            return newList;
        }

        private static Object apply(LambdaFormula func, Object x) {
            Formula formula = Formulas.lambdaApply(func, new ValueFormula<Value>(JavaExecutor.toValue(x)));
            return defaultExecutor.processFormula(formula, null);
        }

        private static Object apply(LambdaFormula func, Object x, Object y) {
            Formula formula = Formulas.lambdaApply(func, new ValueFormula<Value>(JavaExecutor.toValue(x)));
            formula = Formulas.lambdaApply((LambdaFormula)formula, new ValueFormula<Value>(JavaExecutor.toValue(y)));
            return defaultExecutor.processFormula(formula, null);
        }

        public static List<Integer> range(int start, int end) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int i = start; i < end; ++i) {
                result.add(i);
            }
            return result;
        }
    }

    public static class Options {
        @Option(gloss="Whether to convert NumberValue to int/double")
        public boolean convertNumberValues = true;
        @Option(gloss="Print stack trace on exception")
        public boolean printStackTrace = false;
        @Option(gloss="Formula in the grammar whose name startsWith contextPrefix is context sensitive")
        public String contextPrefix = "context:";
        @Option(gloss="Reduce verbosity by automatically appending, for example, edu.stanford.nlp.sempre to java calls")
        public String classPathPrefix = "";
    }
}

