/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

public final class Json {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private Json() {
    }

    public static ObjectMapper getMapper() {
        return OBJECT_MAPPER;
    }

    private static ObjectWriter getWriter(Class<?> view) {
        if (view != null) {
            return Json.getMapper().writerWithView(view);
        }
        return Json.getMapper().writer();
    }

    private static ObjectReader getReader(Class<?> view) {
        if (view != null) {
            return Json.getMapper().readerWithView(view);
        }
        return Json.getMapper().reader();
    }

    public static <T> T readValueHard(String json, Class<T> klass) {
        return Json.readValueHard(json, klass, Object.class);
    }

    public static <T> T readValueHard(String json, Class<T> klass, Class<?> view) {
        try {
            return (T)Json.getReader(view).withType(klass).readValue(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValueHard(String json, TypeReference<T> typeRef) {
        return Json.readValueHard(json, typeRef, Object.class);
    }

    public static <T> T readValueHard(String json, TypeReference<T> typeRef, Class<?> view) {
        try {
            return (T)Json.getReader(view).withType(typeRef).readValue(json);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValueHard(Reader r, Class<T> klass) {
        return Json.readValueHard(r, klass, Object.class);
    }

    public static <T> T readValueHard(Reader r, Class<T> klass, Class<?> view) {
        try {
            return (T)Json.getReader(view).withType(klass).readValue(r);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValueHard(Reader r, TypeReference<T> typeRef) {
        return Json.readValueHard(r, typeRef, Object.class);
    }

    public static <T> T readValueHard(Reader r, TypeReference<T> typeRef, Class<?> view) {
        try {
            return (T)Json.getReader(view).withType(typeRef).readValue(r);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> readMapHard(String json) {
        return Json.readMapHard(json, Object.class);
    }

    public static Map<String, Object> readMapHard(String json, Class<?> view) {
        try {
            return (Map)Json.getReader(view).withType(Map.class).readValue(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String prettyWriteValueAsStringHard(Object o) {
        try {
            return Json.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String writeValueAsStringHard(Object o) {
        return Json.writeValueAsStringHard(o, Object.class);
    }

    public static String writeValueAsStringHard(Object o, Class<?> view) {
        try {
            return Json.getWriter(view).writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] writeValueAsBytesHard(Object o) {
        return Json.writeValueAsBytesHard(o, Object.class);
    }

    public static byte[] writeValueAsBytesHard(Object o, Class<?> view) {
        try {
            return Json.getWriter(view).writeValueAsBytes(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void prettyWriteValueHard(File f, Object o) {
        try {
            Json.getMapper().writerWithDefaultPrettyPrinter().writeValue(f, o);
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeValueHard(File f, Object o) {
        Json.writeValueHard(f, o, Object.class);
    }

    public static void writeValueHard(File f, Object o, Class<?> view) {
        try {
            Json.getWriter(view).writeValue(f, o);
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeValueHard(OutputStream out, Object o) {
        Json.writeValueHard(out, o, Object.class);
    }

    public static void writeValueHard(OutputStream out, Object o, Class<?> view) {
        try {
            Json.getWriter(view).writeValue(out, o);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeValueHard(JsonGenerator jg, Object o) {
        Json.writeValueHard(jg, o, Object.class);
    }

    public static void writeValueHard(JsonGenerator jg, Object o, Class<?> view) {
        try {
            Json.getWriter(view).writeValue(jg, o);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeValueHard(Writer w, Object o) {
        Json.writeValueHard(w, o, Object.class);
    }

    public static void writeValueHard(Writer w, Object o, Class<?> view) {
        try {
            Json.getWriter(view).writeValue(w, o);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        OBJECT_MAPPER.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
    }
}

