/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.NaiveKnowledgeGraph;
import edu.stanford.nlp.sempre.SempreUtils;
import edu.stanford.nlp.sempre.Value;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import fig.basic.Pair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class KnowledgeGraph {
    public static KnowledgeGraph fromLispTree(LispTree tree) {
        if ("graph".equals(((LispTree)tree.child((int)0)).value)) {
            if (tree.children.size() > 1 && ((LispTree)tree.child(1)).isLeaf()) {
                try {
                    String className = ((LispTree)tree.child((int)1)).value;
                    Class<?> classObject = Class.forName(SempreUtils.resolveClassName(className));
                    return (KnowledgeGraph)classObject.getDeclaredMethod("fromLispTree", LispTree.class).invoke(null, tree);
                }
                catch (InvocationTargetException e) {
                    e.getCause().printStackTrace();
                    LogInfo.fail((Object)e.getCause());
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            return NaiveKnowledgeGraph.fromLispTree(tree);
        }
        throw new RuntimeException("Cannot convert " + tree + " to KnowledgeGraph.");
    }

    public static List<Pair<Value, Value>> getReversedPairs(Collection<Pair<Value, Value>> pairs) {
        ArrayList<Pair<Value, Value>> reversed = new ArrayList<Pair<Value, Value>>();
        for (Pair<Value, Value> pair : pairs) {
            reversed.add((Pair<Value, Value>)new Pair((Object)((Value)pair.getSecond()), (Object)((Value)pair.getFirst())));
        }
        return reversed;
    }

    public abstract LispTree toLispTree();

    public abstract LispTree toShortLispTree();

    public String toString() {
        return this.toLispTree().toString();
    }

    public abstract List<Value> joinFirst(Value var1, Collection<Value> var2);

    public abstract List<Value> joinSecond(Value var1, Collection<Value> var2);

    public abstract List<Pair<Value, Value>> filterFirst(Value var1, Collection<Value> var2);

    public abstract List<Pair<Value, Value>> filterSecond(Value var1, Collection<Value> var2);

    public void clean() {
    }
}

