/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import fig.basic.IntPair;
import fig.basic.LispTree;
import fig.basic.MemUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LanguageInfo
implements MemUsage.Instrumented {
    @JsonProperty
    public final List<String> tokens;
    @JsonProperty
    public final List<String> lemmaTokens;
    @JsonProperty
    public final List<String> posTags;
    @JsonProperty
    public final List<String> nerTags;
    @JsonProperty
    public final List<String> nerValues;
    private Map<String, IntPair> lemmaSpans;
    private Set<String> lowercasedSpans;
    @JsonProperty
    public final List<List<DependencyEdge>> dependencyChildren;

    public LanguageInfo() {
        this(new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<List<DependencyEdge>>());
    }

    @JsonCreator
    public LanguageInfo(@JsonProperty(value="tokens") List<String> tokens, @JsonProperty(value="lemmaTokens") List<String> lemmaTokens, @JsonProperty(value="posTags") List<String> posTags, @JsonProperty(value="nerTags") List<String> nerTags, @JsonProperty(value="nerValues") List<String> nerValues, @JsonProperty(value="dependencyChildren") List<List<DependencyEdge>> dependencyChildren) {
        this.tokens = tokens;
        this.lemmaTokens = lemmaTokens;
        this.posTags = posTags;
        this.nerTags = nerTags;
        this.nerValues = nerValues;
        this.dependencyChildren = dependencyChildren;
    }

    public String phrase(int start, int end) {
        return LanguageInfo.sliceSequence(this.tokens, start, end);
    }

    public String lemmaPhrase(int start, int end) {
        return LanguageInfo.sliceSequence(this.lemmaTokens, start, end);
    }

    public String posSeq(int start, int end) {
        return LanguageInfo.sliceSequence(this.posTags, start, end);
    }

    public String canonicalPosSeq(int start, int end) {
        if (start >= end) {
            throw new RuntimeException("Bad indices, start=" + start + ", end=" + end);
        }
        if (end - start == 1) {
            return LanguageUtils.getCanonicalPos(this.posTags.get(start));
        }
        StringBuilder out = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (out.length() > 0) {
                out.append(' ');
            }
            out.append(LanguageUtils.getCanonicalPos(this.posTags.get(i)));
        }
        return out.toString();
    }

    public String nerSeq(int start, int end) {
        return LanguageInfo.sliceSequence(this.nerTags, start, end);
    }

    private static String sliceSequence(List<String> items, int start, int end) {
        if (start >= end) {
            throw new RuntimeException("Bad indices, start=" + start + ", end=" + end);
        }
        if (end - start == 1) {
            return items.get(start);
        }
        StringBuilder out = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (out.length() > 0) {
                out.append(' ');
            }
            out.append(items.get(i));
        }
        return out.toString();
    }

    public String getNormalizedNerSpan(String queryTag, int start, int end) {
        String value = this.nerValues.get(start);
        if (value == null) {
            return null;
        }
        if (!queryTag.equals(this.nerTags.get(start))) {
            return null;
        }
        if (start - 1 >= 0 && value.equals(this.nerValues.get(start - 1))) {
            return null;
        }
        if (end < this.nerValues.size() && value.equals(this.nerValues.get(end))) {
            return null;
        }
        for (int i = start + 1; i < end; ++i) {
            if (value.equals(this.nerValues.get(i))) continue;
            return null;
        }
        value = this.omitComparative(value);
        return value;
    }

    private String omitComparative(String value) {
        if (value.startsWith("<=") || value.startsWith(">=")) {
            return value.substring(2);
        }
        if (value.startsWith("<") || value.startsWith(">")) {
            return value.substring(1);
        }
        return value;
    }

    public String getCanonicalPos(int index) {
        if (index == -1) {
            return "OUT";
        }
        return LanguageUtils.getCanonicalPos(this.posTags.get(index));
    }

    public boolean equalTokens(LanguageInfo other) {
        if (this.tokens.size() != other.tokens.size()) {
            return false;
        }
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (this.tokens.get(i).equals(other.tokens.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equalLemmas(LanguageInfo other) {
        if (this.lemmaTokens.size() != other.lemmaTokens.size()) {
            return false;
        }
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (this.lemmaTokens.get(i).equals(other.lemmaTokens.get(i))) continue;
            return false;
        }
        return true;
    }

    public int numTokens() {
        return this.tokens.size();
    }

    public LanguageInfo remove(int startIndex, int endIndex) {
        if (startIndex > endIndex || startIndex < 0 || endIndex > this.numTokens()) {
            throw new RuntimeException("Illegal start or end index, start: " + startIndex + ", end: " + endIndex + ", info size: " + this.numTokens());
        }
        LanguageInfo res = new LanguageInfo();
        for (int i = 0; i < this.numTokens(); ++i) {
            if (i >= startIndex && i < endIndex) continue;
            res.tokens.add(this.tokens.get(i));
            res.lemmaTokens.add(this.lemmaTokens.get(i));
            res.nerTags.add(this.nerTags.get(i));
            res.nerValues.add(this.nerValues.get(i));
            res.posTags.add(this.posTags.get(i));
        }
        return res;
    }

    public void addSpan(LanguageInfo other, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.tokens.add(other.tokens.get(i));
            this.lemmaTokens.add(other.lemmaTokens.get(i));
            this.posTags.add(other.posTags.get(i));
            this.nerTags.add(other.nerTags.get(i));
            this.nerValues.add(other.nerValues.get(i));
        }
    }

    public List<String> getSpanProperties(int start, int end) {
        ArrayList<String> res = new ArrayList<String>();
        res.add("lemmas=" + this.lemmaPhrase(start, end));
        res.add("pos=" + this.posSeq(start, end));
        res.add("ner=" + this.nerSeq(start, end));
        return res;
    }

    public void addWordInfo(WordInfo wordInfo) {
        this.tokens.add(wordInfo.token);
        this.lemmaTokens.add(wordInfo.lemma);
        this.posTags.add(wordInfo.pos);
        this.nerTags.add(wordInfo.nerTag);
        this.nerValues.add(wordInfo.nerValue);
    }

    public void addWordInfos(List<WordInfo> wordInfos) {
        for (WordInfo wInfo : wordInfos) {
            this.addWordInfo(wInfo);
        }
    }

    public WordInfo getWordInfo(int i) {
        return new WordInfo(this.tokens.get(i), this.lemmaTokens.get(i), this.posTags.get(i), this.nerTags.get(i), this.nerValues.get(i));
    }

    public Set<IntPair> getNamedEntitySpans() {
        LinkedHashSet<IntPair> res = new LinkedHashSet<IntPair>();
        int start = -1;
        String prevTag = "O";
        for (int i = 0; i < this.nerTags.size(); ++i) {
            String currTag = this.nerTags.get(i);
            if (currTag.equals("O")) {
                if (!prevTag.equals("O")) {
                    res.add(new IntPair(start, i));
                    start = -1;
                }
            } else if (!currTag.equals(prevTag)) {
                if (!prevTag.equals("O")) {
                    res.add(new IntPair(start, i));
                }
                start = i;
            }
            prevTag = currTag;
        }
        if (start != -1) {
            res.add(new IntPair(start, this.nerTags.size()));
        }
        return res;
    }

    public Set<IntPair> getProperNounSpans() {
        LinkedHashSet<IntPair> res = new LinkedHashSet<IntPair>();
        int start = -1;
        String prevTag = "O";
        for (int i = 0; i < this.posTags.size(); ++i) {
            String currTag = this.posTags.get(i);
            if (LanguageUtils.isProperNoun(currTag)) {
                if (!LanguageUtils.isProperNoun(prevTag)) {
                    start = i;
                }
            } else if (LanguageUtils.isProperNoun(prevTag)) {
                res.add(new IntPair(start, i));
                start = -1;
            }
            prevTag = currTag;
        }
        if (start != -1) {
            res.add(new IntPair(start, this.posTags.size()));
        }
        return res;
    }

    public Set<IntPair> getNamedEntitiesAndProperNouns() {
        Set<IntPair> res = this.getNamedEntitySpans();
        res.addAll(this.getProperNounSpans());
        return res;
    }

    public Map<String, IntPair> getLemmaSpans() {
        if (this.lemmaSpans == null) {
            this.lemmaSpans = new HashMap<String, IntPair>();
            for (int i = 0; i < this.numTokens() - 1; ++i) {
                for (int j = i + 1; j < this.numTokens(); ++j) {
                    this.lemmaSpans.put(this.lemmaPhrase(i, j), new IntPair(i, j));
                }
            }
        }
        return this.lemmaSpans;
    }

    public Set<String> getLowerCasedSpans() {
        if (this.lowercasedSpans == null) {
            this.lowercasedSpans = new HashSet<String>();
            for (int i = 0; i < this.numTokens() - 1; ++i) {
                for (int j = i + 1; j < this.numTokens(); ++j) {
                    this.lowercasedSpans.add(this.phrase(i, j).toLowerCase());
                }
            }
        }
        return this.lowercasedSpans;
    }

    public boolean matchLemmas(List<WordInfo> wordInfos) {
        for (int i = 0; i < this.numTokens(); ++i) {
            if (!this.matchLemmasFromIndex(wordInfos, i)) continue;
            return true;
        }
        return false;
    }

    private boolean matchLemmasFromIndex(List<WordInfo> wordInfos, int start) {
        if (start + wordInfos.size() > this.numTokens()) {
            return false;
        }
        for (int j = 0; j < wordInfos.size(); ++j) {
            if (wordInfos.get((int)j).lemma.equals(this.lemmaTokens.get(start + j))) continue;
            return false;
        }
        return true;
    }

    public long getBytes() {
        return (long)MemUsage.objectSize((int)(MemUsage.pointerSize * 2)) + MemUsage.getBytes(this.tokens) + MemUsage.getBytes(this.lemmaTokens) + MemUsage.getBytes(this.posTags) + MemUsage.getBytes(this.nerTags) + MemUsage.getBytes(this.nerValues) + MemUsage.getBytes(this.lemmaSpans);
    }

    public boolean isNumberAndDate(int index) {
        return this.posTags.get(index).equals("CD") && this.nerTags.get(index).equals("DATE");
    }

    public static boolean isContentWord(String pos) {
        return pos.equals("NN") || pos.equals("NNS") || pos.startsWith("V") && !pos.equals("VBD-AUX") || pos.startsWith("J");
    }

    public static class WordInfo {
        public final String token;
        public final String lemma;
        public final String pos;
        public final String nerTag;
        public final String nerValue;

        public WordInfo(String token, String lemma, String pos, String nerTag, String nerValue) {
            this.token = token;
            this.lemma = lemma;
            this.pos = pos;
            this.nerTag = nerTag;
            this.nerValue = nerValue;
        }

        public String toString() {
            return this.toLispTree().toString();
        }

        public LispTree toLispTree() {
            LispTree tree = (LispTree)LispTree.proto.newList();
            tree.addChild("wordinfo");
            tree.addChild(this.token);
            tree.addChild(this.lemma);
            tree.addChild(this.pos);
            tree.addChild(this.nerTag);
            return tree;
        }
    }

    public static class LanguageUtils {
        public static boolean sameProperNounClass(String noun1, String noun2) {
            return !(!noun1.equals("NNP") && !noun1.equals("NNPS") || !noun2.equals("NNP") && !noun2.equals("NNPS"));
        }

        public static boolean isProperNoun(String pos) {
            return pos.startsWith("NNP");
        }

        public static boolean isSuperlative(String pos) {
            return pos.equals("RBS") || pos.equals("JJS");
        }

        public static boolean isComparative(String pos) {
            return pos.equals("RBR") || pos.equals("JJR");
        }

        public static boolean isEntity(LanguageInfo info, int i) {
            return LanguageUtils.isProperNoun(info.posTags.get(i)) || !info.nerTags.get(i).equals("O");
        }

        public static boolean isNN(String pos) {
            return pos.startsWith("NN") && !pos.startsWith("NNP");
        }

        public static boolean isContentWord(String pos) {
            return pos.startsWith("N") || pos.startsWith("V") || pos.startsWith("J");
        }

        public static String getLemmaPhrase(List<WordInfo> wordInfos) {
            Object[] res = new String[wordInfos.size()];
            for (int i = 0; i < wordInfos.size(); ++i) {
                res[i] = wordInfos.get((int)i).lemma;
            }
            return Joiner.on((char)' ').join(res);
        }

        public static String getCanonicalPos(String pos) {
            if (pos.startsWith("N")) {
                return "N";
            }
            if (pos.startsWith("V")) {
                return "V";
            }
            if (pos.startsWith("W")) {
                return "W";
            }
            return pos;
        }

        public static String stem(String a) {
            int i = a.indexOf(32);
            if (i != -1) {
                return LanguageUtils.stem(a.substring(0, i)) + ' ' + LanguageUtils.stem(a.substring(i + 1));
            }
            String res = a;
            if (a.equals("having") || a.equals("has")) {
                res = "have";
            } else if (a.equals("using")) {
                res = "use";
            } else if (a.equals("including")) {
                res = "include";
            } else if (a.equals("beginning")) {
                res = "begin";
            } else if (a.equals("utilizing")) {
                res = "utilize";
            } else if (a.equals("featuring")) {
                res = "feature";
            } else if (a.equals("preceding")) {
                res = "precede";
            } else if (a.endsWith("ing")) {
                res = a.substring(0, a.length() - 3);
            } else if (a.endsWith("s") && !a.equals("'s")) {
                res = a.substring(0, a.length() - 1);
            }
            if (res.length() > 0) {
                return res;
            }
            return a;
        }
    }

    public static class DependencyEdge {
        @JsonProperty
        public final String label;
        @JsonProperty
        public final int modifier;

        @JsonCreator
        public DependencyEdge(@JsonProperty(value="label") String label, @JsonProperty(value="modifier") int modifier) {
            this.label = label;
            this.modifier = modifier;
        }

        public String toString() {
            return this.label + "->" + this.modifier;
        }
    }
}

