/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Learner;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.ParserState;
import edu.stanford.nlp.sempre.SempreUtils;
import fig.basic.Evaluation;
import fig.basic.LogInfo;
import fig.basic.Parallelizer;
import fig.basic.StopWatchSet;
import fig.exec.Execution;
import java.util.HashMap;

public class LearnerParallelProcessor
implements Parallelizer.Processor<Example> {
    private final Parser parser;
    private final String prefix;
    private final boolean computeExpectedCounts;
    private Params params;
    private Evaluation evaluation;

    public LearnerParallelProcessor(Parser parser, Params params, String prefix, boolean computeExpectedCounts, Evaluation evaluation) {
        this.prefix = prefix;
        this.parser = parser;
        this.computeExpectedCounts = computeExpectedCounts;
        this.params = params;
        this.evaluation = evaluation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Example ex, int i, int n) {
        LogInfo.begin_track_printAll((String)"%s: example %s/%s: %s", (Object[])new Object[]{this.prefix, i, n, ex.id});
        ex.log();
        Execution.putOutput((String)"example", (Object)i);
        StopWatchSet.begin((String)"Parser.parse");
        ParserState state = this.parser.parse(this.params, ex, this.computeExpectedCounts);
        StopWatchSet.end();
        if (this.computeExpectedCounts) {
            HashMap<String, Double> counts = new HashMap<String, Double>();
            SempreUtils.addToDoubleMap(counts, state.expectedCounts);
            StopWatchSet.begin((String)"Learner.updateWeights");
            LogInfo.begin_track((String)"Updating learner weights", (Object[])new Object[0]);
            if (Learner.opts.verbose >= 2) {
                SempreUtils.logMap(counts, "gradient");
            }
            double sum = 0.0;
            Object object = counts.values().iterator();
            while (object.hasNext()) {
                double v = (Double)object.next();
                sum += v * v;
            }
            LogInfo.logs((String)"L2 norm: %s", (Object[])new Object[]{Math.sqrt(sum)});
            object = this.params;
            synchronized (object) {
                this.params.update(counts);
            }
            counts.clear();
            LogInfo.end_track();
            StopWatchSet.end();
        }
        LogInfo.logs((String)"Current: %s", (Object[])new Object[]{ex.evaluation.summary()});
        Evaluation evaluation = this.evaluation;
        synchronized (evaluation) {
            this.evaluation.add(ex.evaluation);
            LogInfo.logs((String)"Cumulative(%s): %s", (Object[])new Object[]{this.prefix, this.evaluation.summary()});
        }
        LogInfo.end_track();
        ex.clean();
    }
}

