/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Value;
import edu.stanford.nlp.sempre.Values;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ListValue
extends Value {
    public final List<Value> values;

    public ListValue(LispTree tree) {
        this.values = new ArrayList<Value>();
        for (int i = 1; i < tree.children.size(); ++i) {
            this.values.add(Values.fromLispTree((LispTree)tree.child(i)));
        }
    }

    public ListValue(List<Value> values) {
        this.values = values;
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("list");
        for (Value value : this.values) {
            tree.addChild((AbstractLispTree)(value == null ? (LispTree)LispTree.proto.newLeaf(null) : value.toLispTree()));
        }
        return tree;
    }

    @Override
    public void log() {
        for (Value value : this.values) {
            LogInfo.logs((String)"%s", (Object[])new Object[]{value});
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListValue that = (ListValue)o;
        return this.values.equals(that.values);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    public ListValue getSorted() {
        ArrayList<Value> sorted = new ArrayList<Value>(this.values);
        Collections.sort(sorted, (v1, v2) -> (v1 == null ? "null" : v1.sortString()).compareTo(v2 == null ? "null" : v2.sortString()));
        return new ListValue(sorted);
    }

    public ListValue getUnique() {
        ArrayList<Value> sorted = new ArrayList<Value>(new HashSet<Value>(this.values));
        Collections.sort(sorted, (v1, v2) -> (v1 == null ? "null" : v1.sortString()).compareTo(v2 == null ? "null" : v2.sortString()));
        return new ListValue(sorted);
    }
}

