/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Builder;
import edu.stanford.nlp.sempre.Dataset;
import edu.stanford.nlp.sempre.Learner;
import edu.stanford.nlp.sempre.Master;
import fig.basic.Option;
import fig.exec.Execution;
import java.lang.reflect.Constructor;

public class Main
implements Runnable {
    @Option
    public boolean interactive = false;
    @Option
    public boolean server = false;
    @Option
    public String masterType = "edu.stanford.nlp.sempre.Master";

    @Override
    public void run() {
        Builder builder = new Builder();
        builder.build();
        Dataset dataset = new Dataset();
        dataset.read();
        Learner learner = new Learner(builder.parser, builder.params, dataset);
        learner.learn();
        if (this.server || this.interactive) {
            Master master = this.createMaster(this.masterType, builder);
            if (this.server) {
                master.runServer();
            }
            if (this.interactive) {
                master.runInteractivePrompt();
            }
        }
    }

    public Master createMaster(String masterType, Builder builder) {
        try {
            Class<?> masterClass = Class.forName(masterType);
            Constructor<?> constructor = masterClass.getConstructor(Builder.class);
            return (Master)constructor.newInstance(builder);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Execution.run((String[])args, (Object[])new Object[]{"Main", new Main(), Master.getOptionsParser()});
    }
}

