/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import edu.stanford.nlp.sempre.Builder;
import edu.stanford.nlp.sempre.ContextValue;
import edu.stanford.nlp.sempre.Dataset;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Executor;
import edu.stanford.nlp.sempre.FeatureVector;
import edu.stanford.nlp.sempre.Formulas;
import edu.stanford.nlp.sempre.KnowledgeGraph;
import edu.stanford.nlp.sempre.Learner;
import edu.stanford.nlp.sempre.NaiveKnowledgeGraph;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Rule;
import edu.stanford.nlp.sempre.Server;
import edu.stanford.nlp.sempre.Session;
import edu.stanford.nlp.sempre.TypeInference;
import edu.stanford.nlp.sempre.Values;
import fig.basic.IOUtils;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.OptionsParser;
import fig.basic.StopWatchSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jline.console.ConsoleReader;

public class Master {
    public static Options opts = new Options();
    protected Builder builder;
    protected Learner learner;
    protected HashMap<String, Session> sessions = new LinkedHashMap<String, Session>();

    public Master(Builder builder) {
        this.builder = builder;
        this.learner = new Learner(builder.parser, builder.params, new Dataset());
    }

    public Params getParams() {
        return this.builder.params;
    }

    public Session getSession(String id) {
        Session session = this.sessions.get(id);
        if (session == null) {
            session = new Session(id);
            for (String path : Master.opts.scriptPaths) {
                this.processScript(session, path);
            }
            for (String command : Master.opts.commands) {
                this.processQuery(session, command);
            }
            if (id != null) {
                this.sessions.put(id, session);
            }
        }
        return session;
    }

    protected void printHelp() {
        LogInfo.log((Object)"Enter an utterance to parse or one of the following commands:");
        LogInfo.log((Object)"  (help): show this help message");
        LogInfo.log((Object)"  (status): prints out status of the system");
        LogInfo.log((Object)"  (get |option|): get a command-line option (e.g., (get Parser.verbose))");
        LogInfo.log((Object)"  (set |option| |value|): set a command-line option (e.g., (set Parser.verbose 5))");
        LogInfo.log((Object)"  (reload): reload the grammar/parameters");
        LogInfo.log((Object)"  (grammar): prints out the grammar");
        LogInfo.log((Object)"  (params [|file|]): dumps all the model parameters");
        LogInfo.log((Object)"  (select |candidate index|): show information about the |index|-th candidate of the last utterance.");
        LogInfo.log((Object)"  (accept |candidate index|): record the |index|-th candidate as the correct answer for the last utterance.");
        LogInfo.log((Object)"  (answer |answer|): record |answer| as the correct answer for the last utterance (e.g., (answer (list (number 3)))).");
        LogInfo.log((Object)"  (rule |lhs| (|rhs_1| ... |rhs_k|) |sem|): adds a rule to the grammar (e.g., (rule $Number ($TOKEN) (NumberFn)))");
        LogInfo.log((Object)"  (type |logical form|): perform type inference (e.g., (type (number 3)))");
        LogInfo.log((Object)"  (execute |logical form|): execute the logical form (e.g., (execute (call + (number 3) (number 4))))");
        LogInfo.log((Object)"  (def |key| |value|): define a macro to replace |key| with |value| in all commands (e.g., (def type fb:type.object type)))");
        LogInfo.log((Object)"  (context [(user |user|) (date |date|) (exchange |exchange|) (graph |graph|)]): prints out or set the context");
        LogInfo.log((Object)"Press Ctrl-D to exit.");
    }

    public void runServer() {
        Server server = new Server(this);
        server.run();
    }

    public void runInteractivePrompt() {
        Session session = this.getSession("stdin");
        if (Master.opts.printHelp) {
            this.printHelp();
        }
        try {
            String line;
            ConsoleReader reader = new ConsoleReader();
            reader.setPrompt("> ");
            while ((line = reader.readLine()) != null) {
                int indent = LogInfo.getIndLevel();
                try {
                    this.processQuery(session, line);
                }
                catch (Throwable t) {
                    while (LogInfo.getIndLevel() > indent) {
                        LogInfo.end_track();
                    }
                    t.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processScript(Session session, String scriptPath) {
        Iterator it = LispTree.proto.parseFromFile(scriptPath);
        while (it.hasNext()) {
            LispTree tree = (LispTree)it.next();
            this.processQuery(session, tree.toString());
        }
    }

    public synchronized Response processQuery(Session session, String line) {
        line = line.trim();
        Response response = new Response();
        StringWriter stringOut = new StringWriter();
        LogInfo.setFileOut((PrintWriter)new PrintWriter(stringOut));
        if (line.startsWith("(")) {
            this.handleCommand(session, line, response);
        } else {
            this.handleUtterance(session, line, response);
        }
        for (String outLine : stringOut.toString().split("\n")) {
            response.lines.add(outLine);
        }
        LogInfo.setFileOut(null);
        if (!Strings.isNullOrEmpty((String)Master.opts.logPath)) {
            PrintWriter out = IOUtils.openOutAppendHard((String)Master.opts.logPath);
            out.println(Joiner.on((String)"\t").join((Iterable)Lists.newArrayList((Object[])new String[]{"date=" + new Date().toString(), "sessionId=" + session.id, "remote=" + session.remoteHost, "format=" + session.format, "query=" + line, "response=" + this.summaryString(response)})));
            out.close();
        }
        return response;
    }

    String summaryString(Response response) {
        if (response.getExample() != null) {
            return response.getFormulaAnswer();
        }
        if (response.getLines().size() > 0) {
            return response.getLines().get(0);
        }
        return null;
    }

    private void handleUtterance(Session session, String query, Response response) {
        session.updateContext();
        Example.Builder b = new Example.Builder();
        b.setId("session:" + session.id);
        b.setUtterance(query);
        b.setContext(session.context);
        Example ex = b.createExample();
        ex.preprocess();
        this.builder.parser.parse(this.builder.params, ex, false);
        response.ex = ex;
        ex.logWithoutContext();
        if (ex.predDerivations.size() > 0) {
            response.candidateIndex = 0;
            this.printDerivation(response.getDerivation());
        }
        session.updateContext(ex, Master.opts.contextMaxExchanges);
    }

    private void printDerivation(Derivation deriv) {
        HashMap<String, Double> featureVector = new HashMap<String, Double>();
        deriv.incrementAllFeatureVector(1.0, featureVector);
        FeatureVector.logFeatureWeights("Pred", featureVector, this.builder.params);
        LinkedHashMap<String, Integer> choices = new LinkedHashMap<String, Integer>();
        deriv.incrementAllChoices(1, choices);
        FeatureVector.logChoices("Pred", choices);
        LogInfo.begin_track((String)"Top formula", (Object[])new Object[0]);
        LogInfo.logs((String)"%s", (Object[])new Object[]{deriv.formula});
        LogInfo.end_track();
        if (deriv.value != null) {
            LogInfo.begin_track((String)"Top value", (Object[])new Object[0]);
            deriv.value.log();
            LogInfo.end_track();
        }
    }

    private void handleCommand(Session session, String line, Response response) {
        LispTree tree = (LispTree)LispTree.proto.parseFromString(line);
        tree = this.builder.grammar.applyMacros(tree);
        String command = ((LispTree)tree.child((int)0)).value;
        if (command == null || command.equals("help")) {
            this.printHelp();
        } else if (command.equals("status")) {
            LogInfo.begin_track((String)"%d sessions", (Object[])new Object[]{this.sessions.size()});
            for (Session otherSession : this.sessions.values()) {
                LogInfo.log((Object)(otherSession + (session == otherSession ? " *" : "")));
            }
            LogInfo.end_track();
            StopWatchSet.logStats();
        } else if (command.equals("reload")) {
            this.builder.build();
        } else if (command.equals("grammar")) {
            for (Rule rule : this.builder.grammar.rules) {
                LogInfo.logs((String)"%s", (Object[])new Object[]{rule.toLispTree()});
            }
        } else if (command.equals("params")) {
            if (tree.children.size() == 1) {
                this.builder.params.write(LogInfo.stdout);
                if (LogInfo.getFileOut() != null) {
                    this.builder.params.write(LogInfo.getFileOut());
                }
            } else {
                this.builder.params.write(((LispTree)tree.child((int)1)).value);
            }
        } else if (command.equals("get")) {
            if (tree.children.size() != 2) {
                LogInfo.log((Object)"Invalid usage: (get |option|)");
                return;
            }
            String option = ((LispTree)tree.child((int)1)).value;
            LogInfo.logs((String)"%s", (Object[])new Object[]{Master.getOptionsParser().getValue(option)});
        } else if (command.equals("set")) {
            if (tree.children.size() != 3) {
                LogInfo.log((Object)"Invalid usage: (set |option| |value|)");
                return;
            }
            String option = ((LispTree)tree.child((int)1)).value;
            String value = ((LispTree)tree.child((int)2)).value;
            if (!Master.getOptionsParser().parse(new String[]{"-" + option, value})) {
                LogInfo.log((Object)("Unknown option: " + option));
            }
        } else if (command.equals("select") || command.equals("accept") || command.equals("s") || command.equals("a")) {
            if (tree.children.size() != 2) {
                LogInfo.logs((String)"Invalid usage: (%s |candidate index|)", (Object[])new Object[]{command});
                return;
            }
            Example ex = session.getLastExample();
            if (ex == null) {
                LogInfo.log((Object)"No examples - please enter a query first.");
                return;
            }
            int index = Integer.parseInt(((LispTree)tree.child((int)1)).value);
            if (index < 0 || index >= ex.predDerivations.size()) {
                LogInfo.log((Object)("Candidate index out of range: " + index));
                return;
            }
            response.ex = ex;
            response.candidateIndex = index;
            session.updateContextWithNewAnswer(ex, response.getDerivation());
            this.printDerivation(response.getDerivation());
            if (command.equals("accept") || command.equals("a")) {
                ex.setTargetFormula(response.getDerivation().getFormula());
                ex.setTargetValue(response.getDerivation().getValue());
                ex.setContext(session.getContextExcludingLast());
                this.addNewExample(ex);
            }
        } else if (command.equals("answer")) {
            Example ex;
            if (tree.children.size() != 2) {
                LogInfo.log((Object)"Missing answer.");
            }
            if ((ex = session.getLastExample()) == null) {
                LogInfo.log((Object)"Please enter a query first.");
                return;
            }
            ex.setTargetValue(Values.fromLispTree((LispTree)tree.child(1)));
            this.addNewExample(ex);
        } else if (command.equals("rule")) {
            int n = this.builder.grammar.rules.size();
            this.builder.grammar.addStatement(tree.toString());
            for (int i = n; i < this.builder.grammar.rules.size(); ++i) {
                LogInfo.logs((String)"Added %s", (Object[])new Object[]{this.builder.grammar.rules.get(i)});
            }
            this.builder.parser = null;
            this.builder.buildUnspecified();
        } else if (command.equals("type")) {
            LogInfo.logs((String)"%s", (Object[])new Object[]{TypeInference.inferType(Formulas.fromLispTree((LispTree)tree.child(1)))});
        } else if (command.equals("execute")) {
            Example ex = session.getLastExample();
            ContextValue context = ex != null ? ex.context : session.context;
            Executor.Response execResponse = this.builder.executor.execute(Formulas.fromLispTree((LispTree)tree.child(1)), context);
            LogInfo.logs((String)"%s", (Object[])new Object[]{execResponse.value});
        } else if (command.equals("def")) {
            this.builder.grammar.interpretMacroDef(tree);
        } else if (command.equals("context")) {
            if (tree.children.size() == 1) {
                LogInfo.logs((String)"%s", (Object[])new Object[]{session.context});
            } else {
                session.context = new ContextValue(tree);
            }
        } else if (command.equals("loadgraph")) {
            if (tree.children.size() != 2 || !((LispTree)tree.child(1)).isLeaf()) {
                throw new RuntimeException("Invalid argument: argument should be a file path");
            }
            KnowledgeGraph graph = NaiveKnowledgeGraph.fromFile(((LispTree)tree.child((int)1)).value);
            session.context = new ContextValue(session.context.user, session.context.date, session.context.exchanges, graph);
        } else {
            LogInfo.log((Object)("Invalid command: " + tree));
        }
    }

    void addNewExample(Example origEx) {
        Example ex = new Example.Builder().setId(origEx.id).setUtterance(origEx.utterance).setContext(origEx.context).setTargetFormula(origEx.targetFormula).setTargetValue(origEx.targetValue).createExample();
        if (!Strings.isNullOrEmpty((String)Master.opts.newExamplesPath)) {
            LogInfo.begin_track((String)"Adding new example", (Object[])new Object[0]);
            Dataset.appendExampleToFile(Master.opts.newExamplesPath, ex);
            LogInfo.end_track();
        }
        if (Master.opts.onlineLearnExamples) {
            LogInfo.begin_track((String)"Updating parameters", (Object[])new Object[0]);
            this.learner.onlineLearnExample(origEx);
            if (!Strings.isNullOrEmpty((String)Master.opts.newParamsPath)) {
                this.builder.params.write(Master.opts.newParamsPath);
            }
            LogInfo.end_track();
        }
    }

    public static OptionsParser getOptionsParser() {
        OptionsParser parser = new OptionsParser();
        List<String> modules = Arrays.asList(System.getProperty("modules", "core").split(","));
        ArrayList<Object> args = new ArrayList<Object>();
        for (String line : IOUtils.readLinesHard((String)"module-classes.txt")) {
            String[] tokens = line.split(" ");
            if (tokens.length != 2) {
                throw new RuntimeException("Invalid: " + line);
            }
            String module = tokens[0];
            String className = tokens[1];
            if (!modules.contains(tokens[0])) continue;
            String[] classNameTokens = className.split("\\.");
            String group = classNameTokens[classNameTokens.length - 1];
            Object opts = null;
            try {
                for (Field field : Class.forName(className).getDeclaredFields()) {
                    if (!"opts".equals(field.getName())) continue;
                    opts = field.get(null);
                }
            }
            catch (Throwable t) {
                System.out.println("Problem processing: " + line);
                throw new RuntimeException(t);
            }
            if (opts == null) continue;
            args.add(group);
            args.add(opts);
        }
        parser.registerAll(args.toArray(new Object[0]));
        return parser;
    }

    public class Response {
        public Example ex;
        int candidateIndex = -1;
        public Map<String, Object> stats = new LinkedHashMap<String, Object>();
        public List<String> lines = new ArrayList<String>();

        public String getFormulaAnswer() {
            if (this.ex.getPredDerivations().size() == 0) {
                return "(no answer)";
            }
            if (this.candidateIndex == -1) {
                return "(not selected)";
            }
            Derivation deriv = this.getDerivation();
            return deriv.getFormula() + " => " + deriv.getValue();
        }

        public String getAnswer() {
            if (this.ex.getPredDerivations().size() == 0) {
                return "(no answer)";
            }
            if (this.candidateIndex == -1) {
                return "(not selected)";
            }
            Derivation deriv = this.getDerivation();
            deriv.ensureExecuted(Master.this.builder.executor, this.ex.context);
            return deriv.getValue().toString();
        }

        public List<String> getLines() {
            return this.lines;
        }

        public Example getExample() {
            return this.ex;
        }

        public int getCandidateIndex() {
            return this.candidateIndex;
        }

        public Derivation getDerivation() {
            return this.ex.getPredDerivations().get(this.candidateIndex);
        }
    }

    public static class Options {
        @Option(gloss="Execute these commands before starting")
        public List<String> scriptPaths = Lists.newArrayList();
        @Option(gloss="Execute these commands before starting (after scriptPaths)")
        public List<String> commands = Lists.newArrayList();
        @Option(gloss="Write a log of this session to this path")
        public String logPath;
        @Option(gloss="Print help on startup")
        public boolean printHelp = true;
        @Option(gloss="Number of exchanges to keep in the context")
        public int contextMaxExchanges = 0;
        @Option(gloss="Online update weights on new examples.")
        public boolean onlineLearnExamples = true;
        @Option(gloss="Write out new examples to this directory")
        public String newExamplesPath;
        @Option(gloss="Write out new parameters to this directory")
        public String newParamsPath;
        @Option(gloss="Write out new grammar rules")
        public String newGrammarPath;
    }
}

