/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.FeatureVector;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Formulas;
import edu.stanford.nlp.sempre.MergeFormula;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SingleDerivationStream;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import fig.basic.Option;

public class MergeFn
extends SemanticFn {
    public static Options opts = new Options();
    MergeFormula.Mode mode;
    Formula formula;

    @Override
    public void init(LispTree tree) {
        super.init(tree);
        this.mode = MergeFormula.parseMode(((LispTree)tree.child((int)1)).value);
        if (tree.children.size() == 3) {
            this.formula = Formulas.fromLispTree((LispTree)tree.child(2));
        }
    }

    @Override
    public DerivationStream call(final Example ex, final SemanticFn.Callable c) {
        return new SingleDerivationStream(){

            @Override
            public Derivation createDerivation() {
                Formula result;
                if (c.getChildren().size() == 1) {
                    result = c.child((int)0).formula;
                } else if (c.getChildren().size() == 2) {
                    result = new MergeFormula(MergeFn.this.mode, c.child((int)0).formula, c.child((int)1).formula);
                } else {
                    throw new RuntimeException("Bad args: " + c.getChildren());
                }
                Derivation child0 = c.child(0);
                Derivation child1 = c.child(1);
                SemType type = child0.type.meet(child1.type);
                FeatureVector features = new FeatureVector();
                if (MergeFn.opts.verbose >= 5) {
                    LogInfo.logs((String)"MergeFn: %s | %s | %s", (Object[])new Object[]{child0, child1, type});
                }
                if (!type.isValid() && MergeFn.opts.hardTypeCheck) {
                    if (MergeFn.opts.showTypeCheckFailures) {
                        LogInfo.warnings((String)"MergeFn: type check failed: [%s : %s] AND [%s : %s]", (Object[])new Object[]{child0.formula, child0.type, child1.formula, child1.type});
                    }
                    return null;
                }
                if (MergeFn.this.formula != null) {
                    result = new MergeFormula(MergeFn.this.mode, MergeFn.this.formula, result);
                }
                Derivation deriv = new Derivation.Builder().withCallable(c).formula(result).type(type).localFeatureVector(features).createDerivation();
                if (SemanticFn.opts.trackLocalChoices) {
                    deriv.addLocalChoice("MergeFn " + child0.startEndString(ex.getTokens()) + " " + child0.formula + " AND " + child1.startEndString(ex.getTokens()) + " " + child1.formula);
                }
                return deriv;
            }
        };
    }

    public static class Options {
        @Option(gloss="whether to do a hard type-check")
        public boolean hardTypeCheck = true;
        @Option
        public boolean showTypeCheckFailures = false;
        @Option(gloss="Verbose")
        public int verbose = 0;
    }
}

