/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Function;
import edu.stanford.nlp.sempre.Formula;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;
import java.util.List;

public class MergeFormula
extends Formula {
    public final Mode mode;
    public final Formula child1;
    public final Formula child2;

    public MergeFormula(Mode mode, Formula child1, Formula child2) {
        this.mode = mode;
        this.child1 = child1;
        this.child2 = child2;
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild(this.mode.toString());
        tree.addChild((AbstractLispTree)this.child1.toLispTree());
        tree.addChild((AbstractLispTree)this.child2.toLispTree());
        return tree;
    }

    @Override
    public void forEach(Function<Formula, Boolean> func) {
        if (!((Boolean)func.apply((Object)this)).booleanValue()) {
            this.child1.forEach(func);
            this.child2.forEach(func);
        }
    }

    @Override
    public Formula map(Function<Formula, Formula> func) {
        Formula result = (Formula)func.apply((Object)this);
        return result == null ? new MergeFormula(this.mode, this.child1.map(func), this.child2.map(func)) : result;
    }

    @Override
    public List<Formula> mapToList(Function<Formula, List<Formula>> func, boolean alwaysRecurse) {
        List res = (List)func.apply((Object)this);
        if (res.isEmpty() || alwaysRecurse) {
            res.addAll(this.child1.mapToList(func, alwaysRecurse));
            res.addAll(this.child2.mapToList(func, alwaysRecurse));
        }
        return res;
    }

    public static Mode parseMode(String mode) {
        if ("and".equals(mode)) {
            return Mode.and;
        }
        if ("or".equals(mode)) {
            return Mode.or;
        }
        return null;
    }

    @Override
    public boolean equals(Object thatObj) {
        if (!(thatObj instanceof MergeFormula)) {
            return false;
        }
        MergeFormula that = (MergeFormula)thatObj;
        if (this.mode != that.mode) {
            return false;
        }
        if (!this.child1.equals(that.child1)) {
            return false;
        }
        return this.child2.equals(that.child2);
    }

    @Override
    public int computeHashCode() {
        int hash = 2127912214;
        hash = hash * -744332180 + this.mode.toString().hashCode();
        hash = hash * -744332180 + this.child1.hashCode();
        hash = hash * -744332180 + this.child2.hashCode();
        return hash;
    }

    public static enum Mode {
        and,
        or;

    }
}

