/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.MixParserOption;
import edu.stanford.nlp.sempre.MixParserState;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.ParserState;
import edu.stanford.nlp.sempre.SempreUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MixParser
extends Parser {
    public static Options opts = new Options();
    final List<Pair<Parser, MixParserOption>> parsers = new ArrayList<Pair<Parser, MixParserOption>>();
    int iter;
    int numIters;
    String group;

    public MixParser(Parser.Spec spec) {
        super(spec);
        for (String parserAndOptions : MixParser.opts.parsers) {
            Parser parser;
            String[] tokens;
            if (MixParser.opts.verbose >= 1) {
                LogInfo.logs((String)"Adding parser %s", (Object[])new Object[]{parserAndOptions});
            }
            if ((tokens = parserAndOptions.split(":")).length > 2) {
                throw new RuntimeException("Invalid parser options: " + parserAndOptions);
            }
            String parserName = tokens[0];
            try {
                Class<?> parserClass = Class.forName(SempreUtils.resolveClassName(parserName));
                parser = (Parser)parserClass.getConstructor(spec.getClass()).newInstance(spec);
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException("Illegal parser: " + parserName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error while instantiating parser: " + parserName + "\n" + e);
            }
            if (tokens.length > 1) {
                this.parsers.add((Pair<Parser, MixParserOption>)new Pair((Object)parser, (Object)new MixParserOption(this, tokens[1])));
                continue;
            }
            this.parsers.add((Pair<Parser, MixParserOption>)new Pair((Object)parser, (Object)new MixParserOption(this)));
        }
    }

    @Override
    protected void computeCatUnaryRules() {
        this.catUnaryRules = Collections.emptyList();
    }

    @Override
    public ParserState newParserState(Params params, Example ex, boolean computeExpectedCounts) {
        return new MixParserState(this, params, ex, computeExpectedCounts);
    }

    @Override
    public void onBeginDataGroup(int iter, int numIters, String group) {
        this.iter = iter;
        this.numIters = numIters;
        this.group = group;
    }

    public static class Options {
        @Option(gloss="verbosity")
        public int verbose = 1;
        @Option(gloss="list of parsers to use along with options")
        public List<String> parsers = new ArrayList<String>();
    }
}

