/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.MixParser;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

class MixParserOption {
    private final MixParser mixParser;
    private boolean allowedAll = false;
    private List<Pair<String, String>> allowedGroupsAndIter = new ArrayList<Pair<String, String>>();

    public MixParserOption(MixParser mixParser) {
        this.mixParser = mixParser;
        this.allowedAll = true;
    }

    public MixParserOption(MixParser mixParser, String optionString) {
        String[] tokens;
        this.mixParser = mixParser;
        for (String option : tokens = optionString.split(",")) {
            String[] subtokens = option.split("-");
            if (subtokens.length == 1) {
                this.allowedGroupsAndIter.add((Pair<String, String>)new Pair((Object)subtokens[0], (Object)"all"));
                continue;
            }
            for (int i = 1; i < subtokens.length; ++i) {
                if (!Pattern.matches("^([0-9]*(n?xc)?)$", subtokens[i])) {
                    throw new RuntimeException("Invalid iteration options: " + subtokens[i]);
                }
                this.allowedGroupsAndIter.add((Pair<String, String>)new Pair((Object)subtokens[0], (Object)subtokens[i]));
            }
        }
    }

    public boolean isAllowed(boolean computeExpectedCounts) {
        if (this.allowedAll) {
            return true;
        }
        String xcFlag = computeExpectedCounts ? "xc" : "nxc";
        return this.allowedGroupsAndIter.contains(new Pair((Object)this.mixParser.group, (Object)"all")) || this.allowedGroupsAndIter.contains(new Pair((Object)this.mixParser.group, (Object)("" + this.mixParser.iter))) || this.allowedGroupsAndIter.contains(new Pair((Object)this.mixParser.group, (Object)xcFlag)) || this.allowedGroupsAndIter.contains(new Pair((Object)this.mixParser.group, (Object)("" + this.mixParser.iter + xcFlag)));
    }
}

