/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.MixParser;
import edu.stanford.nlp.sempre.MixParserOption;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.ParserState;
import fig.basic.LogInfo;
import fig.basic.Pair;
import java.util.HashMap;

class MixParserState
extends ParserState {
    public MixParserState(Parser parser, Params params, Example ex, boolean computeExpectedCounts) {
        super(parser, params, ex, computeExpectedCounts);
    }

    @Override
    public void infer() {
        for (Pair<Parser, MixParserOption> pair : ((MixParser)this.parser).parsers) {
            if (!((MixParserOption)pair.getSecond()).isAllowed(this.computeExpectedCounts)) {
                if (MixParser.opts.verbose < 1) continue;
                LogInfo.logs((String)"Skipping %s", (Object[])new Object[]{((Parser)pair.getFirst()).getClass().getSimpleName()});
                continue;
            }
            if (MixParser.opts.verbose >= 1) {
                LogInfo.begin_track((String)"Using %s", (Object[])new Object[]{((Parser)pair.getFirst()).getClass().getSimpleName()});
            }
            ParserState parserState = ((Parser)pair.getFirst()).newParserState(this.params, this.ex, false);
            parserState.infer();
            this.predDerivations.addAll(parserState.predDerivations);
            if (MixParser.opts.verbose < 1) continue;
            LogInfo.logs((String)"Number of derivations: %d", (Object[])new Object[]{parserState.predDerivations.size()});
            LogInfo.end_track();
        }
        this.ensureExecuted();
        if (this.computeExpectedCounts) {
            this.expectedCounts = new HashMap();
            ParserState.computeExpectedCounts(this.predDerivations, this.expectedCounts);
        }
    }
}

