/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.FeatureExtractor;

public abstract class MultipleDerivationStream
implements DerivationStream {
    private Derivation nextDeriv;
    int numGenerated = 0;

    public abstract Derivation createDerivation();

    @Override
    public boolean hasNext() {
        if (this.nextDeriv != null) {
            return true;
        }
        this.nextDeriv = this.createDerivation();
        return this.nextDeriv != null;
    }

    @Override
    public Derivation next() {
        if (this.nextDeriv == null) {
            throw new RuntimeException("No more derivations!");
        }
        Derivation deriv = this.nextDeriv;
        if (FeatureExtractor.containsDomain("derivRank")) {
            ++this.numGenerated;
            if (this.numGenerated <= 3) {
                deriv.addFeature("derivRank", deriv.rule.sem.toString() + " " + this.numGenerated);
            } else if (this.numGenerated <= 5) {
                deriv.addFeature("derivRank", deriv.rule.sem.toString() + " 4:5");
            } else if (this.numGenerated <= 10) {
                deriv.addFeature("derivRank", deriv.rule.sem.toString() + " 6:10");
            } else {
                deriv.addFeature("derivRank", deriv.rule.sem.toString() + " 11:");
            }
        }
        this.nextDeriv = this.createDerivation();
        return deriv;
    }

    @Override
    public Derivation peek() {
        if (this.nextDeriv == null) {
            throw new RuntimeException("No more derivations!");
        }
        return this.nextDeriv;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Cannot remove from DerivationStream");
    }

    @Override
    public int estimatedSize() {
        return 2;
    }
}

