/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.CanonicalNames;
import edu.stanford.nlp.sempre.KnowledgeGraph;
import edu.stanford.nlp.sempre.NameValue;
import edu.stanford.nlp.sempre.StringValue;
import edu.stanford.nlp.sempre.Value;
import edu.stanford.nlp.sempre.Values;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;
import fig.basic.MapUtils;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NaiveKnowledgeGraph
extends KnowledgeGraph {
    public final List<KnowledgeGraphTriple> triples;
    public Map<Value, List<KnowledgeGraphTriple>> relationToTriples;
    public Map<Value, List<KnowledgeGraphTriple>> firstToTriples;
    public Map<Value, List<KnowledgeGraphTriple>> secondToTriples;

    public NaiveKnowledgeGraph(Collection<KnowledgeGraphTriple> triples) {
        this.triples = new ArrayList<KnowledgeGraphTriple>(triples);
        this.precomputeMappings();
    }

    public void precomputeMappings() {
        this.relationToTriples = new HashMap<Value, List<KnowledgeGraphTriple>>();
        this.firstToTriples = new HashMap<Value, List<KnowledgeGraphTriple>>();
        this.secondToTriples = new HashMap<Value, List<KnowledgeGraphTriple>>();
        for (KnowledgeGraphTriple triple : this.triples) {
            MapUtils.addToList(this.relationToTriples, (Object)triple.r, (Object)triple);
            MapUtils.addToList(this.firstToTriples, (Object)triple.e1, (Object)triple);
            MapUtils.addToList(this.secondToTriples, (Object)triple.e2, (Object)triple);
        }
    }

    @Override
    public List<Value> joinFirst(Value r, Collection<Value> firsts) {
        if (CanonicalNames.isReverseProperty(r)) {
            return this.joinSecond(CanonicalNames.reverseProperty(r), firsts);
        }
        ArrayList<Value> seconds = new ArrayList<Value>();
        List<KnowledgeGraphTriple> relationTriples = this.relationToTriples.get(r);
        if (relationTriples != null) {
            for (KnowledgeGraphTriple triple : relationTriples) {
                if (!firsts.contains(triple.e1)) continue;
                seconds.add(triple.e2);
            }
        }
        return seconds;
    }

    @Override
    public List<Value> joinSecond(Value r, Collection<Value> seconds) {
        if (CanonicalNames.isReverseProperty(r)) {
            return this.joinFirst(CanonicalNames.reverseProperty(r), seconds);
        }
        ArrayList<Value> firsts = new ArrayList<Value>();
        List<KnowledgeGraphTriple> relationTriples = this.relationToTriples.get(r);
        if (relationTriples != null) {
            for (KnowledgeGraphTriple triple : relationTriples) {
                if (!seconds.contains(triple.e2)) continue;
                firsts.add(triple.e1);
            }
        }
        return firsts;
    }

    @Override
    public List<Pair<Value, Value>> filterFirst(Value r, Collection<Value> firsts) {
        if (CanonicalNames.isReverseProperty(r)) {
            return NaiveKnowledgeGraph.getReversedPairs(this.filterSecond(CanonicalNames.reverseProperty(r), firsts));
        }
        ArrayList<Pair<Value, Value>> pairs = new ArrayList<Pair<Value, Value>>();
        List<KnowledgeGraphTriple> relationTriples = this.relationToTriples.get(r);
        if (relationTriples != null) {
            for (KnowledgeGraphTriple triple : relationTriples) {
                if (!firsts.contains(triple.e1)) continue;
                pairs.add((Pair<Value, Value>)new Pair((Object)triple.e1, (Object)triple.e2));
            }
        }
        return pairs;
    }

    @Override
    public List<Pair<Value, Value>> filterSecond(Value r, Collection<Value> seconds) {
        if (CanonicalNames.isReverseProperty(r)) {
            return NaiveKnowledgeGraph.getReversedPairs(this.filterFirst(CanonicalNames.reverseProperty(r), seconds));
        }
        ArrayList<Pair<Value, Value>> pairs = new ArrayList<Pair<Value, Value>>();
        List<KnowledgeGraphTriple> relationTriples = this.relationToTriples.get(r);
        if (relationTriples != null) {
            for (KnowledgeGraphTriple triple : relationTriples) {
                if (!seconds.contains(triple.e2)) continue;
                pairs.add((Pair<Value, Value>)new Pair((Object)triple.e1, (Object)triple.e2));
            }
        }
        return pairs;
    }

    public static KnowledgeGraph fromLispTree(LispTree tree) {
        ArrayList<KnowledgeGraphTriple> triples = new ArrayList<KnowledgeGraphTriple>();
        for (int i = 2; i < tree.children.size(); ++i) {
            triples.add(new KnowledgeGraphTriple((LispTree)tree.child(i)));
        }
        return new NaiveKnowledgeGraph(triples);
    }

    public static KnowledgeGraph fromFile(String path) {
        return NaiveKnowledgeGraph.fromLispTree((LispTree)LispTree.proto.parseFromFile(path).next());
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("graph");
        tree.addChild("NaiveKnowledgeGraph");
        for (KnowledgeGraphTriple triple : this.triples) {
            tree.addChild((AbstractLispTree)triple.toLispTree());
        }
        return tree;
    }

    @Override
    public LispTree toShortLispTree() {
        if (this.triples.size() > 1000) {
            LispTree tree = (LispTree)LispTree.proto.newList();
            tree.addChild("graph");
            tree.addChild("NaiveKnowledgeGraph");
            tree.addChild("TooManyTriples");
            return tree;
        }
        return this.toLispTree();
    }

    public static class KnowledgeGraphTriple {
        public final Value e1;
        public final Value r;
        public final Value e2;

        public KnowledgeGraphTriple(Value e1, Value r, Value e2) {
            this.e1 = e1;
            this.r = r;
            this.e2 = e2;
        }

        public KnowledgeGraphTriple(String e1, String r, String e2) {
            this.e1 = new StringValue(e1);
            this.r = new StringValue(r);
            this.e2 = new StringValue(e2);
        }

        public KnowledgeGraphTriple(LispTree tree) {
            if (tree.children.size() != 3) {
                throw new RuntimeException("Invalid triple size (" + tree.children.size() + " != 3): " + tree);
            }
            this.e1 = KnowledgeGraphTriple.valueFromLispTree((LispTree)tree.child(0));
            this.r = KnowledgeGraphTriple.valueFromLispTree((LispTree)tree.child(1));
            this.e2 = KnowledgeGraphTriple.valueFromLispTree((LispTree)tree.child(2));
        }

        protected static Value valueFromLispTree(LispTree tree) {
            if (tree.isLeaf()) {
                return new NameValue(tree.value, null);
            }
            return Values.fromLispTree(tree);
        }

        public LispTree toLispTree() {
            LispTree tree = (LispTree)LispTree.proto.newList();
            tree.addChild((AbstractLispTree)this.e1.toLispTree());
            tree.addChild((AbstractLispTree)this.r.toLispTree());
            tree.addChild((AbstractLispTree)this.e2.toLispTree());
            return tree;
        }

        public String toString() {
            return "<" + this.e1 + ", " + this.r + ", " + this.e2 + ">";
        }
    }
}

