/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Value;
import fig.basic.LispTree;
import fig.basic.LogInfo;

public class NameValue
extends Value {
    public final String id;
    public final String description;

    public NameValue(LispTree tree) {
        this.id = ((LispTree)tree.child((int)1)).value;
        this.description = tree.children.size() > 2 ? ((LispTree)tree.child((int)2)).value : null;
        assert (this.id != null) : tree;
    }

    public NameValue(String id) {
        this(id, null);
    }

    public NameValue(String id, String description) {
        if (id == null) {
            LogInfo.errors((String)"Got null id, description is %s", (Object[])new Object[]{description});
            id = "fb:en.null";
        }
        this.id = id;
        this.description = description;
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("name");
        tree.addChild(this.id);
        if (this.description != null) {
            tree.addChild(this.description);
        }
        return tree;
    }

    @Override
    public String sortString() {
        return this.id;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameValue that = (NameValue)o;
        return this.id.equals(that.id);
    }
}

