/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.LanguageAnalyzer;
import edu.stanford.nlp.sempre.LanguageInfo;
import edu.stanford.nlp.sempre.NumberValue;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SingleDerivationStream;
import edu.stanford.nlp.sempre.ValueFormula;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import fig.basic.Option;
import java.util.ArrayList;
import java.util.List;

public class NumberFn
extends SemanticFn {
    public static Options opts = new Options();
    private List<String> requests;

    private boolean request(String req) {
        return this.requests == null || this.requests.contains(req);
    }

    @Override
    public void init(LispTree tree) {
        super.init(tree);
        if (tree.children.size() > 1) {
            this.requests = new ArrayList<String>();
            for (int i = 1; i < tree.children.size(); ++i) {
                this.requests.add(((LispTree)tree.child((int)1)).value);
            }
        }
    }

    @Override
    public DerivationStream call(final Example ex, final SemanticFn.Callable c) {
        return new SingleDerivationStream(){

            @Override
            public Derivation createDerivation() {
                String value;
                Derivation deriv = this.check(ex.languageInfo, c.getStart(), c.getEnd());
                if (deriv != null) {
                    return deriv;
                }
                if (NumberFn.opts.alsoTestByConversion && NumberFn.this.request("NUMBER") & c.getEnd() - c.getStart() == 1 && (value = ex.languageInfo.tokens.get(c.getStart())) != null) {
                    try {
                        NumberValue numberValue = new NumberValue(Double.parseDouble(value));
                        SemType type = numberValue.value == (double)((int)numberValue.value) ? SemType.intType : SemType.floatType;
                        return new Derivation.Builder().withCallable(c).formula(new ValueFormula<NumberValue>(numberValue)).type(type).createDerivation();
                    }
                    catch (NumberFormatException numberValue) {
                        // empty catch block
                    }
                }
                if (NumberFn.opts.alsoTestByIsolatedNER) {
                    String phrase = ex.phraseString(c.getStart(), c.getEnd());
                    LanguageInfo languageInfo = LanguageAnalyzer.getSingleton().analyze(phrase);
                    deriv = this.check(languageInfo, 0, languageInfo.numTokens());
                    if (deriv != null) {
                        return deriv;
                    }
                }
                return null;
            }

            public Derivation check(LanguageInfo languageInfo, int start, int end) {
                NumberValue numberValue;
                String value;
                if (NumberFn.this.request("NUMBER") && (value = languageInfo.getNormalizedNerSpan("NUMBER", start, end)) != null) {
                    try {
                        NumberValue numberValue2 = new NumberValue(Double.parseDouble(value));
                        if (NumberFn.opts.allowedRange != null && (numberValue2.value < NumberFn.opts.allowedRange.get(0) || numberValue2.value > NumberFn.opts.allowedRange.get(1))) {
                            LogInfo.warnings((String)"NumberFn: %f is outside of the allowed range %s", (Object[])new Object[]{numberValue2.value, NumberFn.opts.allowedRange});
                            return null;
                        }
                        SemType type = numberValue2.value == (double)((int)numberValue2.value) ? SemType.intType : SemType.floatType;
                        return new Derivation.Builder().withCallable(c).formula(new ValueFormula<NumberValue>(numberValue2)).type(type).createDerivation();
                    }
                    catch (NumberFormatException e) {
                        LogInfo.warnings((String)"NumberFn: Cannot convert NerSpan \"%s\" to a number", (Object[])new Object[]{value});
                    }
                }
                if (NumberFn.this.request("ORDINAL") && (value = languageInfo.getNormalizedNerSpan("ORDINAL", start, end)) != null) {
                    try {
                        NumberValue numberValue3 = NumberFn.opts.unitless ? new NumberValue(Double.parseDouble(value)) : new NumberValue(Double.parseDouble(value), "fb:en.ordinal_number");
                        SemType type = SemType.intType;
                        return new Derivation.Builder().withCallable(c).formula(new ValueFormula<NumberValue>(numberValue3)).type(type).createDerivation();
                    }
                    catch (NumberFormatException e) {
                        LogInfo.warnings((String)"NumberFn: Cannot convert NerSpan \"%s\" to a number", (Object[])new Object[]{value});
                    }
                }
                if (NumberFn.this.request("PERCENT") && (value = languageInfo.getNormalizedNerSpan("PERCENT", start, end)) != null) {
                    try {
                        numberValue = NumberFn.opts.unitless ? new NumberValue(Double.parseDouble(value.substring(1))) : new NumberValue(0.01 * Double.parseDouble(value.substring(1)));
                        SemType type = SemType.floatType;
                        return new Derivation.Builder().withCallable(c).formula(new ValueFormula<NumberValue>(numberValue)).type(type).createDerivation();
                    }
                    catch (NumberFormatException e) {
                        LogInfo.warnings((String)"NumberFn: Cannot convert NerSpan \"%s\" to a number", (Object[])new Object[]{value});
                    }
                }
                if (NumberFn.this.request("MONEY") && (value = languageInfo.getNormalizedNerSpan("MONEY", start, end)) != null) {
                    try {
                        numberValue = NumberFn.opts.unitless ? new NumberValue(Double.parseDouble(value.substring(1))) : new NumberValue(Double.parseDouble(value.substring(1)), "fb:en.dollar");
                        SemType type = SemType.floatType;
                        return new Derivation.Builder().withCallable(c).formula(new ValueFormula<NumberValue>(numberValue)).type(type).createDerivation();
                    }
                    catch (NumberFormatException e) {
                        LogInfo.warnings((String)"NumberFn: Cannot convert NerSpan \"%s\" to a number", (Object[])new Object[]{value});
                    }
                }
                return null;
            }
        };
    }

    public static class Options {
        @Option(gloss="Omit units")
        public boolean unitless = false;
        @Option(gloss="Also test numbers by try converting to float (instead of using NER tags)")
        public boolean alsoTestByConversion = false;
        @Option(gloss="Also test numbers by applying NER on just the phrase")
        public boolean alsoTestByIsolatedNER = false;
        @Option(gloss="range of allowed numbers. e.g. null: no limits, Lists.newArrayList(0,100): 0-100 inclusive")
        public List<Double> allowedRange = null;
    }
}

