/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Value;
import fig.basic.Fmt;
import fig.basic.LispTree;

public class NumberValue
extends Value {
    public static final String unitless = "fb:en.unitless";
    public static final String yearUnit = "fb:en.year";
    public final double value;
    public final String unit;

    public NumberValue(double value) {
        this(value, unitless);
    }

    public NumberValue(double value, String unit) {
        this.value = value;
        this.unit = unit;
    }

    public NumberValue(LispTree tree) {
        this.value = Double.parseDouble(((LispTree)tree.child((int)1)).value);
        this.unit = 2 < tree.children.size() ? ((LispTree)tree.child((int)2)).value : unitless;
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("number");
        tree.addChild(Fmt.D((double)this.value));
        if (!this.unit.equals(unitless)) {
            tree.addChild(this.unit);
        }
        return tree;
    }

    @Override
    public String sortString() {
        return "" + this.value;
    }

    @Override
    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberValue that = (NumberValue)o;
        if (this.value != that.value) {
            return false;
        }
        return this.unit.equals(that.unit);
    }
}

