/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Value;
import edu.stanford.nlp.sempre.Values;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PairListValue
extends Value {
    public final List<Pair<Value, Value>> pairs;
    protected static final LispTree NULL_LEAF = (LispTree)LispTree.proto.newLeaf(null);

    public PairListValue(LispTree tree) {
        this.pairs = new ArrayList<Pair<Value, Value>>();
        for (int i = 1; i < tree.children.size(); ++i) {
            this.pairs.add((Pair<Value, Value>)new Pair((Object)Values.fromLispTree((LispTree)((LispTree)tree.child(i)).child(0)), (Object)Values.fromLispTree((LispTree)((LispTree)tree.child(i)).child(1))));
        }
    }

    public PairListValue(List<Pair<Value, Value>> pairs) {
        this.pairs = pairs;
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("pairs");
        for (Pair<Value, Value> pair : this.pairs) {
            Value first = (Value)pair.getFirst();
            Value second = (Value)pair.getSecond();
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList((AbstractLispTree)(first == null ? NULL_LEAF : first.toLispTree()), (AbstractLispTree)(second == null ? NULL_LEAF : second.toLispTree()))));
        }
        return tree;
    }

    @Override
    public void log() {
        for (Pair<Value, Value> pair : this.pairs) {
            LogInfo.logs((String)"%s | %s", (Object[])new Object[]{pair.getFirst(), pair.getSecond()});
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PairListValue that = (PairListValue)o;
        return this.pairs.equals(that.pairs);
    }

    @Override
    public int hashCode() {
        return this.pairs.hashCode();
    }

    public PairListValue getSorted() {
        ArrayList<Pair<Value, Value>> sorted = new ArrayList<Pair<Value, Value>>(this.pairs);
        Collections.sort(sorted, (p1, p2) -> PairListValue.getQuickStringOfPair((Pair<Value, Value>)p1).compareTo(PairListValue.getQuickStringOfPair((Pair<Value, Value>)p2)));
        return new PairListValue(sorted);
    }

    private static String getQuickStringOfPair(Pair<Value, Value> pair) {
        Value v1 = (Value)pair.getFirst();
        Value v2 = (Value)pair.getSecond();
        return (v1 == null ? "null" : v1.sortString()) + " " + (v2 == null ? "null" : v2.sortString());
    }
}

