/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.HasScore;

class PrioritizedDerivationStream
implements Comparable<PrioritizedDerivationStream>,
HasScore {
    public final DerivationStream derivStream;
    public final double priority;
    public double probSum;

    PrioritizedDerivationStream(DerivationStream derivStream, double priority, double probSum) {
        this.derivStream = derivStream;
        this.priority = priority;
        this.probSum = probSum;
    }

    @Override
    public int compareTo(PrioritizedDerivationStream o) {
        if (this.priority > o.priority) {
            return -1;
        }
        if (this.priority < o.priority) {
            return 1;
        }
        return 0;
    }

    @Override
    public double getScore() {
        return this.derivStream.peek().score;
    }

    public void addProb(double prob) {
        this.probSum += prob;
    }
}

