/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Joiner;
import edu.stanford.nlp.sempre.CoarseParser;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.ParserState;
import edu.stanford.nlp.sempre.ReinforcementParserState;
import edu.stanford.nlp.sempre.Rule;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.MapUtils;
import fig.basic.Option;
import fig.exec.Execution;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReinforcementParser
extends Parser {
    public static Options opts = new Options();
    Map<String, Map<String, List<Rule>>> leftToRightSiblingMap = new HashMap<String, Map<String, List<Rule>>>();
    Map<String, Map<String, List<Rule>>> rightToLeftSiblingMap = new HashMap<String, Map<String, List<Rule>>>();
    Map<String, List<Rule>> terminalsToRulesList = new HashMap<String, List<Rule>>();
    final CoarseParser coarseParser = new CoarseParser(this.grammar);
    public static final String SEARCH_PREFIX = "search_";
    public final String searchPrefix;

    public ReinforcementParser(Parser.Spec spec) {
        super(spec);
        for (Rule rule : this.grammar.rules) {
            if (rule.rhs.size() > 2) {
                throw new RuntimeException("We assume that the grammar is binarized, rule: " + rule);
            }
            if (rule.rhs.size() == 2) {
                String left = rule.rhs.get(0);
                String right = rule.rhs.get(1);
                this.addToSiblingMap(left, right, rule, this.leftToRightSiblingMap);
                this.addToSiblingMap(right, left, rule, this.rightToLeftSiblingMap);
            }
            if (!rule.isRhsTerminals()) continue;
            MapUtils.addToList(this.terminalsToRulesList, (Object)Joiner.on((char)' ').join(rule.rhs), (Object)rule);
        }
        if (Parser.opts.visualizeChartFilling) {
            this.chartFillOut = IOUtils.openOutAppendEasy((String)Execution.getFile((String)"chartfill"));
        }
        this.searchPrefix = ReinforcementParser.opts.simulateNonRlObjective ? "" : SEARCH_PREFIX;
        LogInfo.logs((String)"ReinforcementParser(): search prefix is %s", (Object[])new Object[]{this.searchPrefix});
    }

    private void addToSiblingMap(String keySibling, String valueSibling, Rule rule, Map<String, Map<String, List<Rule>>> siblingToSiblingMap) {
        Map<String, List<Rule>> valueSiblingMap = siblingToSiblingMap.get(keySibling);
        if (valueSiblingMap == null) {
            valueSiblingMap = new HashMap<String, List<Rule>>();
            siblingToSiblingMap.put(keySibling, valueSiblingMap);
        }
        MapUtils.addToList(valueSiblingMap, (Object)valueSibling, (Object)rule);
    }

    @Override
    public ParserState newParserState(Params params, Example ex, boolean computeExpectedCounts) {
        if (computeExpectedCounts) {
            if (ReinforcementParser.opts.simulateNonRlObjective) {
                return new ReinforcementParserState.StateBuilder().parser(this).params(params).example(ex).samplingStrategy("max").computeExpectedCounts(true).createState();
            }
            return new ReinforcementParserState.StateBuilder().parser(this).params(params).example(ex).samplingStrategy("proposal").computeExpectedCounts(true).createState();
        }
        return new ReinforcementParserState.StateBuilder().parser(this).params(params).example(ex).samplingStrategy("max").computeExpectedCounts(false).createState();
    }

    @Override
    public Params getSearchParams(Params params) {
        return params.copyParamsByPrefix(this.searchPrefix);
    }

    public static class Options {
        @Option(gloss="Whether to do coarse pruning")
        public boolean efficientCoarsePrune = true;
        @Option(gloss="Whether to do importance sampling")
        public double multiplicativeBonus = 1000.0;
        @Option(gloss="Number of samples")
        public int numOfSamplesPerExample = 1;
        @Option(gloss="Whether to update gradient only for correct moves")
        public boolean updateGradientForCorrectMovesOnly = true;
        @Option(gloss="Low probability for which we don't unroll the stream")
        public double lowProb = 0.01;
        @Option(gloss="Whether to simulate the log liklihood objective")
        public boolean simulateNonRlObjective = false;
        @Option(gloss="Whether to always unroll (even at test time)")
        public boolean alwaysUnroll = false;
    }
}

