/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.stanford.nlp.sempre.FloatingParser;
import edu.stanford.nlp.sempre.Json;
import edu.stanford.nlp.sempre.RuleSource;
import edu.stanford.nlp.sempre.SemanticFn;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;
import fig.basic.Pair;
import java.util.LinkedHashMap;
import java.util.List;

public class Rule {
    public static Rule nullRule = new Rule(null, null, null);
    public static final String rootCat = "$ROOT";
    public static final String tokenCat = "$TOKEN";
    public static final String phraseCat = "$PHRASE";
    public static final String lemmaTokenCat = "$LEMMA_TOKEN";
    public static final String lemmaPhraseCat = "$LEMMA_PHRASE";
    public static final List<String> specialCats = Lists.newArrayList((Object[])new String[]{"$ROOT", "$TOKEN", "$PHRASE", "$LEMMA_TOKEN", "$LEMMA_PHRASE"});
    public final String lhs;
    public final List<String> rhs;
    public final SemanticFn sem;
    public List<Pair<String, Double>> info;
    public RuleSource source = null;
    private String semRepn = null;
    private String stringRepn;

    public static boolean isCat(String item) {
        return item.charAt(0) == '$';
    }

    public String getSemRepn() {
        if (this.semRepn == null) {
            this.semRepn = this.sem.getClass().getSimpleName();
        }
        return this.semRepn;
    }

    public Rule(String lhs, List<String> rhs, SemanticFn sem) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.sem = sem;
    }

    public String toString() {
        if (this.stringRepn == null) {
            String semStr = this.sem == null ? "NullSemanticFn" : this.sem.toString();
            int maxLength = 100;
            if (semStr.length() > maxLength) {
                semStr = String.format("%s...(%d total)", semStr.substring(0, maxLength), semStr.length());
            }
            this.stringRepn = this.lhs + " -> " + (this.rhs == null ? "" : Joiner.on((char)' ').join(this.rhs)) + " " + semStr;
        }
        return this.stringRepn;
    }

    public void addInfo(String key, double value) {
        if (this.info == null) {
            this.info = Lists.newArrayList();
        }
        this.info.add((Pair<String, Double>)Pair.newPair((Object)key, (Object)value));
    }

    public Rule setInfo(Rule rule) {
        this.info = rule.info;
        return this;
    }

    public SemanticFn getSem() {
        return this.sem;
    }

    public String getLhs() {
        return this.lhs;
    }

    public boolean isCatUnary() {
        return this.rhs.size() == 1 && Rule.isCat(this.rhs.get(0));
    }

    public boolean isRhsTerminals() {
        for (int i = 0; i < this.rhs.size(); ++i) {
            if (!Rule.isCat(this.rhs.get(i))) continue;
            return false;
        }
        return true;
    }

    public int numRhsCats() {
        int ret = 0;
        for (int i = 0; i < this.rhs.size(); ++i) {
            if (!Rule.isCat(this.rhs.get(i))) continue;
            ++ret;
        }
        return ret;
    }

    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("rule");
        tree.addChild(this.lhs);
        tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList(this.rhs)));
        tree.addChild((AbstractLispTree)this.sem.toLispTree());
        if (this.info != null) {
            for (Pair<String, Double> p : this.info) {
                tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList((String)p.getFirst(), "" + p.getSecond())));
            }
        }
        if (this.source != null) {
            tree.addChild(this.source.toJson());
        }
        return tree;
    }

    public double getInfoTag(String infoTag) {
        if (this.info != null) {
            for (Pair<String, Double> p : this.info) {
                if (!((String)p.getFirst()).equals(infoTag)) continue;
                return (Double)p.getSecond();
            }
        }
        return -1.0;
    }

    public boolean isFloating() {
        double f = this.getInfoTag("floating");
        double a = this.getInfoTag("anchored");
        if (f == 1.0) {
            return true;
        }
        if (f == 0.0) {
            return false;
        }
        return a == 1.0 ? false : FloatingParser.opts.defaultIsFloating;
    }

    public boolean isAnchored() {
        double f = this.getInfoTag("floating");
        double a = this.getInfoTag("anchored");
        if (a == 1.0) {
            return true;
        }
        if (a == 0.0) {
            return false;
        }
        return f == 1.0 ? false : !FloatingParser.opts.defaultIsFloating;
    }

    public boolean isInduced() {
        double a = this.getInfoTag("induced");
        return a == 1.0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Rule)) {
            return false;
        }
        return ((Rule)o).toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toJson() {
        LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
        jsonMap.put("lhs", this.lhs);
        jsonMap.put("rhs", this.rhs);
        if (this.source != null) {
            jsonMap.put("source", this.source);
        }
        if (this.info != null) {
            for (Pair<String, Double> p : this.info) {
                jsonMap.put((String)p.getFirst(), p.getSecond());
            }
        }
        jsonMap.put("sem", this.sem.toString());
        return Json.writeValueAsStringHard(jsonMap);
    }
}

