/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.FeatureExtractor;
import edu.stanford.nlp.sempre.FeatureVector;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SingleDerivationStream;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import fig.basic.Option;
import java.util.List;

public class SelectFn
extends SemanticFn {
    public static Options opts = new Options();
    int position = -1;

    public SelectFn() {
    }

    public SelectFn(int position) {
        this.init((LispTree)LispTree.proto.newList("SelectFn", position + ""));
    }

    @Override
    public void init(LispTree tree) {
        super.init(tree);
        this.position = Integer.valueOf(((LispTree)tree.child((int)1)).value);
    }

    @Override
    public DerivationStream call(final Example ex, final SemanticFn.Callable c) {
        return new SingleDerivationStream(){

            @Override
            public Derivation createDerivation() {
                FeatureVector features = new FeatureVector();
                if (FeatureExtractor.containsDomain("skipPos")) {
                    for (int i = 0; i < c.getChildren().size(); ++i) {
                        if (i == SelectFn.this.position) continue;
                        Derivation child = c.child(i);
                        for (int index = child.start; index < child.end; ++index) {
                            List<String> posTags = ex.languageInfo.posTags;
                            features.add("skipPos", posTags.get(index));
                            if (SelectFn.opts.verbose <= 0) continue;
                            LogInfo.logs((String)"SelectFn: adding pos-skipping feature, pos: %s, word: %s", (Object[])new Object[]{posTags.get(index), ex.languageInfo.tokens.get(index)});
                        }
                    }
                }
                return new Derivation.Builder().withCallable(c).withFormulaFrom(c.child(SelectFn.this.position)).localFeatureVector(features).createDerivation();
            }
        };
    }

    public static class Options {
        @Option(gloss="Verbose")
        public int verbose = 0;
    }
}

