/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.stanford.nlp.sempre.AtomicSemType;
import edu.stanford.nlp.sempre.FuncSemType;
import edu.stanford.nlp.sempre.TopSemType;
import edu.stanford.nlp.sempre.UnionSemType;
import fig.basic.LispTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class SemType {
    public static final SemType topType = new TopSemType();
    public static final SemType bottomType = new UnionSemType();
    public static final SemType stringType = new AtomicSemType("fb:type.text");
    public static final SemType intType = new AtomicSemType("fb:type.int");
    public static final SemType floatType = new AtomicSemType("fb:type.float");
    public static final SemType dateType = new AtomicSemType("fb:type.datetime");
    public static final SemType timeType = new AtomicSemType("fb:type.time");
    public static final SemType numberType = new AtomicSemType("fb:type.number");
    public static final SemType numberOrDateType = new UnionSemType(numberType, dateType);
    public static final SemType entityType = new AtomicSemType("fb:common.topic");
    public static final SemType anyType = new AtomicSemType("fb:type.any");
    public static final FuncSemType topTopFunc = new FuncSemType(topType, topType);
    public static final FuncSemType anyAnyFunc = new FuncSemType(anyType, anyType);
    public static final FuncSemType compareFunc = new FuncSemType(numberOrDateType, numberOrDateType);

    public abstract boolean isValid();

    public abstract SemType meet(SemType var1);

    public abstract SemType reverse();

    public abstract SemType apply(SemType var1);

    public SemType getArgType() {
        return this.reverse().apply(topType);
    }

    public SemType getRetType() {
        return this.apply(topType);
    }

    public abstract LispTree toLispTree();

    @JsonValue
    public String toString() {
        return this.toLispTree().toString();
    }

    @JsonCreator
    public static SemType fromString(String s) {
        return SemType.fromLispTree((LispTree)LispTree.proto.parseFromString(s));
    }

    public static SemType fromLispTree(LispTree tree) {
        if (tree.isLeaf()) {
            if (tree.value.equals("top")) {
                return topType;
            }
            return new AtomicSemType(tree.value);
        }
        if ("union".equals(((LispTree)tree.child((int)0)).value)) {
            ArrayList<SemType> result = new ArrayList<SemType>();
            for (int i = 1; i < tree.children.size(); ++i) {
                result.add(SemType.fromLispTree((LispTree)tree.child(i)));
            }
            return new UnionSemType(result);
        }
        if ("->".equals(((LispTree)tree.child((int)0)).value)) {
            SemType result = SemType.fromLispTree((LispTree)tree.child(tree.children.size() - 1));
            for (int i = tree.children.size() - 2; i >= 1; --i) {
                result = new FuncSemType(SemType.fromLispTree((LispTree)tree.child(i)), result);
            }
            return result;
        }
        throw new RuntimeException("Invalid type: " + tree);
    }

    public static SemType newAtomicSemType(String type) {
        return new AtomicSemType(type);
    }

    public static SemType newFuncSemType(String argType, String retType) {
        return new FuncSemType(argType, retType);
    }

    public static SemType newUnionSemType(Collection<String> types) {
        ArrayList<SemType> t = new ArrayList<SemType>();
        for (String x : types) {
            t.add(new AtomicSemType(x));
        }
        return new UnionSemType(t).simplify();
    }

    public static SemType newUnionSemType(String ... types) {
        return SemType.newUnionSemType(Arrays.asList(types));
    }
}

