/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import fig.basic.LogInfo;
import fig.basic.MapUtils;
import fig.basic.Option;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SemTypeHierarchy {
    public static Options opts = new Options();
    public static final SemTypeHierarchy singleton = new SemTypeHierarchy();
    private Map<String, Set<String>> supertypesMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> subtypesMap = new HashMap<String, Set<String>>();

    public SemTypeHierarchy() {
        this.addSupertype("fb:type.boolean", "fb:type.boolean");
        this.addSupertype("fb:type.boolean", "fb:type.any");
        this.addSupertype("fb:type.int", "fb:type.int");
        this.addSupertype("fb:type.int", "fb:type.number");
        this.addSupertype("fb:type.int", "fb:type.any");
        this.addSupertype("fb:type.float", "fb:type.float");
        this.addSupertype("fb:type.float", "fb:type.number");
        this.addSupertype("fb:type.float", "fb:type.any");
        this.addSupertype("fb:type.datetime", "fb:type.datetime");
        this.addSupertype("fb:type.datetime", "fb:type.any");
        this.addSupertype("fb:type.text", "fb:type.text");
        this.addSupertype("fb:type.text", "fb:type.any");
        this.addSupertype("fb:type.number", "fb:type.number");
        this.addSupertype("fb:type.number", "fb:type.any");
        this.addSupertype("fb:common.topic", "fb:common.topic");
        this.addSupertype("fb:common.topic", "fb:type.any");
        this.addSupertype("fb:type.any", "fb:type.any");
    }

    public void addEntitySupertypes(String type) {
        this.addSupertype(type, type);
        this.addSupertype(type, "fb:common.topic");
        this.addSupertype(type, "fb:type.any");
    }

    public void addSupertype(String subtype, String supertype) {
        MapUtils.addToSet(this.supertypesMap, (Object)subtype, (Object)supertype);
        MapUtils.addToSet(this.subtypesMap, (Object)supertype, (Object)subtype);
    }

    public Set<String> getSupertypes(String type) {
        Set<String> set = this.supertypesMap.get(type);
        if (set == null) {
            if (SemTypeHierarchy.opts.failOnUnknownTypes) {
                LogInfo.fails((String)"SemTypeHierarchy.getSupertypes: don't know about type %s", (Object[])new Object[]{type});
            }
            this.addEntitySupertypes(type);
            set = this.supertypesMap.get(type);
        }
        return set;
    }

    public Set<String> getSubtypes(String type) {
        Set<String> set = this.subtypesMap.get(type);
        if (set == null) {
            if (SemTypeHierarchy.opts.failOnUnknownTypes) {
                LogInfo.fails((String)"SemTypeHierarchy.getSubtypes: don't know about type %s", (Object[])new Object[]{type});
            }
            this.addEntitySupertypes(type);
            set = this.supertypesMap.get(type);
        }
        return set;
    }

    public static class Options {
        @Option(gloss="Throw an error if the type is not registered in the type hierarchy.")
        public boolean failOnUnknownTypes = false;
    }
}

