/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.ChildDerivationsGroup;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Formulas;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Rule;
import fig.basic.LispTree;
import fig.basic.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class SemanticFn {
    public static final Options opts = new Options();
    private LispTree tree;

    public void init(LispTree tree) {
        this.tree = tree;
    }

    public abstract DerivationStream call(Example var1, Callable var2);

    public LispTree toLispTree() {
        return this.tree;
    }

    public String toString() {
        return this.tree.toString();
    }

    public void addFeedback(Example ex) {
    }

    public void sortOnFeedback(Params params) {
    }

    public boolean supportFilteringOnTypeData() {
        return false;
    }

    public Collection<ChildDerivationsGroup> getFilteredDerivations(List<Derivation> derivations1, List<Derivation> derivations2) {
        throw new UnsupportedOperationException();
    }

    public static class CallInfo
    implements Callable {
        final String cat;
        final int start;
        final int end;
        final Rule rule;
        final List<Derivation> children;
        public static final CallInfo NULL_INFO = new CallInfo("", -1, -1, Rule.nullRule, new ArrayList<Derivation>());

        public CallInfo(String cat, int start, int end, Rule rule, List<Derivation> children) {
            this.cat = cat;
            this.start = start;
            this.end = end;
            this.rule = rule;
            this.children = children;
        }

        @Override
        public String getCat() {
            return this.cat;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public Rule getRule() {
            return this.rule;
        }

        @Override
        public List<Derivation> getChildren() {
            return this.children;
        }

        @Override
        public Derivation child(int i) {
            return this.children.get(i);
        }

        @Override
        public String childStringValue(int i) {
            return Formulas.getString(this.children.get((int)i).formula);
        }
    }

    public static interface Callable {
        public String getCat();

        public int getStart();

        public int getEnd();

        public Rule getRule();

        public List<Derivation> getChildren();

        public Derivation child(int var1);

        public String childStringValue(int var1);
    }

    public static class Options {
        @Option(gloss="Whether or not to add to Derivation.localChoices during function application (for debugging only).")
        public boolean trackLocalChoices = false;
    }
}

