/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import fig.basic.LogInfo;
import fig.basic.MapUtils;
import java.util.Map;

public final class SempreUtils {
    private SempreUtils() {
    }

    public static String resolveClassName(String name) {
        if (name.startsWith("edu.") || name.startsWith("org.") || name.startsWith("com.") || name.startsWith("net.")) {
            return name;
        }
        return "edu.stanford.nlp.sempre." + name;
    }

    public static <K, V> void logMap(Map<K, V> map, String desc) {
        LogInfo.begin_track((String)"Logging %s map", (Object[])new Object[]{desc});
        for (K key : map.keySet()) {
            LogInfo.log((Object)(key + "\t" + map.get(key)));
        }
        LogInfo.end_track();
    }

    public static void addToDoubleMap(Map<String, Double> mutatedMap, Map<String, Double> addedMap) {
        for (String key : addedMap.keySet()) {
            MapUtils.incr(mutatedMap, (Object)key, (double)addedMap.get(key));
        }
    }
}

