/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.collect.Lists;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import edu.stanford.nlp.sempre.ContextValue;
import edu.stanford.nlp.sempre.DateValue;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Json;
import edu.stanford.nlp.sempre.Master;
import edu.stanford.nlp.sempre.NameValue;
import edu.stanford.nlp.sempre.NumberValue;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.SecureIdentifiers;
import edu.stanford.nlp.sempre.Session;
import edu.stanford.nlp.sempre.StringValue;
import edu.stanford.nlp.sempre.TableValue;
import edu.stanford.nlp.sempre.UriValue;
import edu.stanford.nlp.sempre.Value;
import fig.basic.Fmt;
import fig.basic.IOUtils;
import fig.basic.LispTree;
import fig.basic.ListUtils;
import fig.basic.LogInfo;
import fig.basic.MapUtils;
import fig.basic.Option;
import fig.basic.SysInfoUtils;
import fig.basic.ValueComparator;
import fig.html.HtmlElement;
import fig.html.HtmlUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Server {
    public static Options opts = new Options();
    Master master;
    public static final HtmlUtils H = new HtmlUtils();

    public Server(Master master) {
        this.master = master;
    }

    void run() {
        try {
            String hostname = SysInfoUtils.getHostName();
            HttpServer server = HttpServer.create(new InetSocketAddress(Server.opts.port), 10);
            ExecutorService pool = Executors.newFixedThreadPool(Server.opts.numThreads);
            server.createContext("/", new Handler());
            server.setExecutor(pool);
            server.start();
            LogInfo.logs((String)"Server started at http://%s:%s/sempre", (Object[])new Object[]{hostname, Server.opts.port});
            LogInfo.log((Object)"Press Ctrl-D to terminate.");
            while (LogInfo.stdin.readLine() != null) {
            }
            LogInfo.log((Object)"Shutting down server...");
            server.stop(0);
            LogInfo.log((Object)"Shutting down executor pool...");
            pool.shutdown();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    class ExchangeState {
        HttpExchange exchange;
        Map<String, String> reqParams = new HashMap<String, String>();
        String remoteHost;
        HttpCookie cookie;
        boolean isNewSession;
        String format;
        public final String freebaseWebsite = "http://www.freebase.com/";

        boolean jsonFormat() {
            return this.format.equals("json");
        }

        public ExchangeState(HttpExchange exchange) throws IOException {
            String uriPath;
            this.exchange = exchange;
            URI uri = exchange.getRequestURI();
            this.remoteHost = exchange.getRemoteAddress().getHostName();
            String[] tokens = uri.toString().split("\\?");
            if (tokens.length == 2) {
                for (String s : tokens[1].split("&")) {
                    String[] kv = s.split("=", 2);
                    try {
                        String key = URLDecoder.decode(kv[0], "UTF-8");
                        String value = URLDecoder.decode(kv[1], "UTF-8");
                        LogInfo.logs((String)"%s => %s", (Object[])new Object[]{key, value});
                        this.reqParams.put(key, value);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            this.format = (String)MapUtils.get(this.reqParams, (Object)"format", (Object)"html");
            String cookieStr = exchange.getRequestHeaders().getFirst("Cookie");
            if (cookieStr != null) {
                this.cookie = HttpCookie.parse(cookieStr).get(0);
                this.isNewSession = false;
            } else {
                this.cookie = !this.jsonFormat() ? new HttpCookie("sessionId", SecureIdentifiers.getId()) : null;
                this.isNewSession = true;
            }
            String sessionId = null;
            if (this.cookie != null) {
                sessionId = this.cookie.getValue();
            }
            if (Server.opts.verbose >= 2) {
                LogInfo.logs((String)"GET %s from %s (%ssessionId=%s)", (Object[])new Object[]{uri, this.remoteHost, this.isNewSession ? "new " : "", sessionId});
            }
            if ((uriPath = uri.getPath()).equals("/")) {
                uriPath = uriPath + "index.html";
            }
            if (uriPath.equals("/sempre")) {
                this.handleQuery(sessionId);
            } else {
                this.getFile(Server.opts.basePath + uriPath);
            }
            exchange.close();
        }

        String getMimeType(String path) {
            String[] tokens = path.split("\\.");
            String ext = tokens[tokens.length - 1];
            if (ext.equals("html")) {
                return "text/html";
            }
            if (ext.equals("css")) {
                return "text/css";
            }
            if (ext.equals("jpeg")) {
                return "image/jpeg";
            }
            if (ext.equals("gif")) {
                return "image/gif";
            }
            return "text/plain";
        }

        void setHeaders(String mimeType) throws IOException {
            Headers headers = this.exchange.getResponseHeaders();
            headers.set("Content-Type", mimeType);
            headers.set("Access-Control-Allow-Origin", "*");
            if (this.isNewSession && this.cookie != null) {
                headers.set("Set-Cookie", this.cookie.toString());
            }
            this.exchange.sendResponseHeaders(200, 0L);
        }

        private HtmlElement makeInputBox(String line, String action) {
            return H.div().child(H.form().action(action).child(H.text(line == null ? "" : line).cls("question").autofocus().size(50).name("q")).child(H.button("Go").cls("ask")).end());
        }

        private HtmlElement makeTooltip(HtmlElement main, HtmlElement aux) {
            return H.a().cls("info").child(main).child(H.span().cls("tooltip").child(aux));
        }

        private HtmlElement makeTooltip(HtmlElement main, HtmlElement aux, String link) {
            return H.a().href(link).cls("info").child(main).child(H.span().cls("tooltip").child(aux));
        }

        public String id2website(String id) {
            assert (id.startsWith("fb:")) : id;
            return "http://www.freebase.com/" + id.substring(3).replaceAll("\\.", "/");
        }

        HtmlElement valueToElem(Value value) {
            if (value == null) {
                return H.span();
            }
            if (value instanceof NameValue) {
                NameValue nameValue = (NameValue)value;
                return H.a().href(this.id2website(nameValue.id)).child(nameValue.description == null ? nameValue.id : nameValue.description);
            }
            if (value instanceof NumberValue) {
                NumberValue numberValue = (NumberValue)value;
                return H.span().child(Fmt.D((double)numberValue.value) + (numberValue.unit.equals("fb:en.unitless") ? "" : " " + numberValue.unit));
            }
            if (value instanceof UriValue) {
                UriValue uriValue = (UriValue)value;
                return H.a().href(uriValue.value).child(uriValue.value);
            }
            if (value instanceof DateValue) {
                DateValue dateValue = (DateValue)value;
                return H.span().child(dateValue.year + (dateValue.month == -1 ? "" : "-" + dateValue.month + (dateValue.day == -1 ? "" : "-" + dateValue.day)));
            }
            if (value instanceof StringValue) {
                return H.span().child(((StringValue)value).value);
            }
            if (value instanceof TableValue) {
                HtmlElement table = H.table().cls("valueTable");
                HtmlElement header = H.tr();
                boolean first = true;
                for (String string : ((TableValue)value).header) {
                    if (!first) {
                        header.child(H.td("&nbsp;&nbsp;&nbsp;"));
                    }
                    first = false;
                    header.child(H.td(H.b(string)));
                }
                table.child(header);
                for (List list : ((TableValue)value).rows) {
                    HtmlElement row = H.tr();
                    first = true;
                    for (Value x : list) {
                        if (!first) {
                            row.child(H.td("&nbsp;&nbsp;&nbsp;"));
                        }
                        first = false;
                        row.child(H.td(this.valueToElem(x)));
                    }
                    table.child(row);
                }
                return table;
            }
            return H.span().child(value.toString());
        }

        private HtmlElement makeAnswerBox(Master.Response response, String uri) {
            HtmlElement answer = response.getExample().getPredDerivations().size() == 0 ? H.span().child("(none)") : this.valueToElem(response.getDerivation().getValue());
            return H.table().child(H.tr().child(H.td(this.makeTooltip(H.span().cls("correctButton").child("[Correct]"), H.div().cls("bubble").child("If this answer is correct, click to add as a new training example!"), uri + "&accept=" + response.getCandidateIndex()))).child(H.td(H.span().cls("answer").child(answer))).end());
        }

        private HtmlElement makeGroup(List<HtmlElement> items) {
            HtmlElement table = H.table().cls("groupResponse");
            for (HtmlElement item : items) {
                table.child(H.tr().child(H.td(item)));
            }
            return table;
        }

        HtmlElement makeDetails(Master.Response response, String uri) {
            Example ex = response.getExample();
            ArrayList<HtmlElement> items = new ArrayList<HtmlElement>();
            if (Server.opts.htmlVerbose >= 1) {
                items.add(this.makeLexical(ex));
            }
            if (ex.getPredDerivations().size() > 0) {
                if (Server.opts.htmlVerbose >= 1) {
                    items.add(this.makeDerivation(ex, response.getDerivation(), true));
                    items.add(this.makeFeatures(response.getDerivation(), false));
                }
                items.add(this.makeCandidates(ex, uri));
            }
            return H.div().cls("details").child(this.makeGroup(items));
        }

        HtmlElement makeDerivation(Example ex, Derivation deriv, boolean moreInfo) {
            HtmlElement table = H.table();
            table.child(H.tr().child(H.td(this.makeDerivationHelper(ex, deriv, "", moreInfo))));
            String header = "Derivation";
            return H.div().child(H.span().cls("listHeader").child(header)).child(table);
        }

        HtmlElement makeDerivationHelper(Example ex, Derivation deriv, String indent, boolean moreInfo) {
            HtmlElement cat;
            if (moreInfo) {
                HtmlElement tooltip = H.div();
                tooltip.child(H.span(deriv.rule.toString()).cls("nowrap"));
                tooltip.child(this.makeFeatures(deriv, true));
                cat = this.makeTooltip(H.span(deriv.cat), tooltip);
            } else {
                cat = H.span(deriv.cat);
            }
            String description = cat + "[&nbsp;" + H.span().child(ex.phraseString(deriv.start, deriv.end)).cls("word") + "] &rarr; " + deriv.formula;
            HtmlElement node = H.div().child(indent + description);
            for (Derivation child : deriv.children) {
                node.child(this.makeDerivationHelper(ex, child, indent + "&nbsp;&nbsp;&nbsp;&nbsp;", moreInfo));
            }
            return node;
        }

        HtmlElement makeFeatures(Derivation deriv, boolean local) {
            String header;
            double value;
            String feature;
            HtmlElement table = H.table();
            Params params = Server.this.master.getParams();
            HashMap<String, Double> features = new HashMap<String, Double>();
            if (local) {
                deriv.incrementLocalFeatureVector(1.0, features);
            } else {
                deriv.incrementAllFeatureVector(1.0, features);
            }
            ArrayList entries = Lists.newArrayList();
            double sumValue = 0.0;
            for (Map.Entry entry : features.entrySet()) {
                feature = (String)entry.getKey();
                if ((Double)entry.getValue() == 0.0) continue;
                value = (Double)entry.getValue() * params.getWeight(feature);
                sumValue += value;
                entries.add(new AbstractMap.SimpleEntry<String, Double>(feature, value));
            }
            Collections.sort(entries, new ValueComparator(false));
            table.child(H.tr().child(H.td(H.b("Feature"))).child(H.td(H.b("Value"))).child(H.td(H.b("Weight"))));
            for (Map.Entry entry : entries) {
                feature = (String)entry.getKey();
                value = (Double)entry.getValue();
                double weight = params.getWeight(feature);
                table.child(H.tr().child(H.td(feature)).child(H.td(Fmt.D((double)MapUtils.getDouble(features, (Object)feature, (double)0.0)))).child(H.td(Fmt.D((double)weight))));
            }
            if (local) {
                double localScore = deriv.localScore(params);
                double score = deriv.getScore();
                header = deriv.children == null ? String.format("Local features (score = %s)", Fmt.D((double)score)) : String.format("Local features (score = %s + %s = %s)", Fmt.D((double)(score - localScore)), Fmt.D((double)localScore), Fmt.D((double)score));
            } else {
                header = String.format("All features (score=%s, prob=%s)", Fmt.D((double)deriv.getScore()), Fmt.D((double)deriv.getProb()));
            }
            return H.div().child(H.span().cls("listHeader").child(header)).child(table);
        }

        HtmlElement linkSelect(int index, String uri, String str) {
            return H.a().href(uri + "&select=" + index).child(str);
        }

        private HtmlElement makeCandidates(Example ex, String uri) {
            HtmlElement table = H.table().cls("candidateTable");
            HtmlElement header = H.tr().child(H.td(H.b("Rank"))).child(H.td(H.b("Score"))).child(H.td(H.b("Answer")));
            if (Server.opts.htmlVerbose >= 1) {
                header.child(H.td(H.b("Formula")));
            }
            table.child(header);
            for (int i = 0; i < ex.getPredDerivations().size(); ++i) {
                Derivation deriv = ex.getPredDerivations().get(i);
                HtmlElement correct = this.makeTooltip(H.span().cls("correctButton").child("[Correct]"), H.div().cls("bubble").child("If this answer is correct, click to add as a new training example!"), uri + "&accept=" + i);
                String value = this.shorten(deriv.getValue() == null ? "" : deriv.getValue().toString(), 200);
                HtmlElement formula = this.makeTooltip(H.span(deriv.getFormula().toString()), H.div().cls("nowrap").child(this.makeDerivation(ex, deriv, false)), uri + "&select=" + i);
                HtmlElement row = H.tr().child(H.td(this.linkSelect(i, uri, i + " " + correct)).cls("nowrap")).child(H.td(Fmt.D((double)deriv.getScore()))).child(H.td(value)).style("width:250px");
                if (Server.opts.htmlVerbose >= 1) {
                    row.child(H.td(formula));
                }
                table.child(row);
            }
            return H.div().child(H.span().cls("listHeader").child("Candidates")).child(table);
        }

        private String shorten(String s, int n) {
            if (s.length() <= n) {
                return s;
            }
            return s.substring(0, n / 2) + "..." + s.substring(s.length() - n / 2);
        }

        private void markLexical(Derivation deriv, CandidatePredicates[] predicates) {
            if (deriv.getRule() != null && deriv.getRule().getSem() != null && deriv.getRule().getSem().getClass().getSimpleName().equals("LexiconFn")) {
                predicates[deriv.getStart()].add(deriv.getFormula(), deriv.getEnd() - deriv.getStart(), deriv.getScore());
            }
            for (Derivation child : deriv.getChildren()) {
                this.markLexical(child, predicates);
            }
        }

        double[] toDoubleArray(List<Double> l) {
            double[] a = new double[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                a[i] = l.get(i);
            }
            return a;
        }

        HtmlElement makeLexical(Example ex) {
            HtmlElement predicatesElem = H.tr();
            HtmlElement tokensElem = H.tr();
            CandidatePredicates[] predicates = new CandidatePredicates[ex.getTokens().size()];
            for (int i = 0; i < ex.getTokens().size(); ++i) {
                predicates[i] = new CandidatePredicates();
            }
            for (Derivation deriv : ex.getPredDerivations()) {
                this.markLexical(deriv, predicates);
            }
            for (int i = 0; i < ex.getTokens().size(); ++i) {
                tokensElem.child(H.td(this.makeTooltip(H.span().cls("word").child(ex.getTokens().get(i)), H.span().cls("tag").child("POS: " + ex.languageInfo.posTags.get(i)), "")));
                if (predicates[i].size() == 0) {
                    predicatesElem.child(H.td(""));
                    continue;
                }
                HtmlElement pe = H.table().cls("predInfo");
                int[] perm = ListUtils.sortedIndices((double[])this.toDoubleArray(predicates[i].scores), (boolean)true);
                HashSet<String> formulaSet = new HashSet<String>();
                for (int j : perm) {
                    String formula = predicates[i].formatPredicate(j);
                    if (formulaSet.contains(formula)) continue;
                    formulaSet.add(formula);
                    double score = predicates[i].scores.get(j);
                    pe.child(H.tr().child(H.td(formula)).child(H.td(Fmt.D((double)score))));
                }
                predicatesElem.child(H.td(this.makeTooltip(H.span().child(predicates[i].formatPredicate(perm[0])), pe, "")));
            }
            return H.div().cls("lexicalResponse").child(H.span().cls("listHeader").child("Lexical Triggers")).child(H.table().child(predicatesElem).child(tokensElem));
        }

        String makeJson(Master.Response response) {
            HashMap json = new HashMap();
            ArrayList items = new ArrayList();
            json.put("candidates", items);
            for (Derivation deriv : response.getExample().getPredDerivations()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                Value value = deriv.getValue();
                if (value instanceof UriValue) {
                    item.put("url", ((UriValue)value).value);
                } else if (value instanceof TableValue) {
                    TableValue tableValue = (TableValue)value;
                    item.put("header", tableValue.header);
                    ArrayList rowsObj = new ArrayList();
                    item.put("rows", rowsObj);
                    for (List<Value> row : tableValue.rows) {
                        ArrayList<String> rowObj = new ArrayList<String>();
                        for (Value v : row) {
                            rowObj.add(v.toString());
                        }
                        rowsObj.add(rowObj);
                    }
                } else {
                    item.put("value", value.toString());
                }
                item.put("score", deriv.score);
                item.put("prob", deriv.prob);
                items.add(item);
            }
            return Json.writeValueAsStringHard(json);
        }

        Master.Response processQuery(Session session, String query) {
            try {
                return Server.this.master.processQuery(session, query);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }

        boolean ensureQueryIsLast(Session session, String query) {
            Master.Response response;
            return query == null || query.equals(session.getLastQuery()) || (response = this.processQuery(session, query)) != null;
        }

        void handleQuery(String sessionId) throws IOException {
            String accept;
            String query = this.reqParams.get("q");
            Session session = Server.this.master.getSession(sessionId);
            session.remoteHost = this.remoteHost;
            session.format = this.format;
            if (query == null) {
                query = session.getLastQuery();
            }
            if (query == null) {
                query = "";
            }
            LogInfo.logs((String)"Server.handleQuery %s: %s", (Object[])new Object[]{session.id, query});
            if (this.jsonFormat()) {
                this.setHeaders("application/json");
            } else {
                this.setHeaders("text/html");
            }
            PrintWriter out = new PrintWriter(new OutputStreamWriter(this.exchange.getResponseBody()));
            if (!this.jsonFormat()) {
                out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println(H.html().open());
                out.println(H.head().child(H.title(Server.opts.title)).child(H.link().rel("stylesheet").type("text/css").href("main.css")).child(H.script().src("main.js")).end());
                out.println(H.body().open());
                if (Server.opts.headerPath != null) {
                    for (String line : IOUtils.readLinesHard((String)Server.opts.headerPath)) {
                        out.println(line);
                    }
                }
            }
            String uri = this.exchange.getRequestURI().toString();
            String select = this.reqParams.get("select");
            if (select != null) {
                query = this.ensureQueryIsLast(session, query) ? ((LispTree)LispTree.proto.newList("select", select)).toString() : null;
            }
            if ((accept = this.reqParams.get("accept")) != null) {
                query = this.ensureQueryIsLast(session, query) ? ((LispTree)LispTree.proto.newList("accept", accept)).toString() : null;
            }
            Master.Response masterResponse = null;
            if (query != null) {
                masterResponse = this.processQuery(session, query);
            }
            if (session.context.exchanges.size() > 0 && !this.jsonFormat()) {
                HtmlElement context = H.table().cls("context");
                for (ContextValue.Exchange e : session.context.exchanges) {
                    HtmlElement row = H.tr().child(H.td(H.span().cls("word").child(e.utterance)));
                    row.child(H.td(H.span("&nbsp;&nbsp;&nbsp;&nbsp;"))).child(H.td(e.value.toString()));
                    if (Server.opts.htmlVerbose >= 1) {
                        row.child(H.td(H.span("&nbsp;&nbsp;&nbsp;&nbsp;"))).child(H.td(e.formula.toString()));
                    }
                    context.child(row);
                }
                out.println(context.toString());
            }
            if (!this.jsonFormat()) {
                String defaultQuery = query != null ? query : session.getLastQuery();
                out.println(this.makeInputBox(defaultQuery, uri).toString());
            }
            if (masterResponse != null) {
                Example ex = masterResponse.getExample();
                if (ex != null) {
                    if (!this.jsonFormat()) {
                        out.println(this.makeAnswerBox(masterResponse, uri).toString());
                        out.println(this.makeDetails(masterResponse, uri).toString());
                    } else {
                        out.println(this.makeJson(masterResponse));
                    }
                }
                if (!this.jsonFormat() && Server.opts.htmlVerbose >= 1) {
                    out.println(H.elem("pre").open());
                    for (String outLine : masterResponse.getLines()) {
                        out.println(outLine);
                    }
                    out.println(H.elem("pre").close());
                }
            } else if (query != null && !this.jsonFormat()) {
                out.println(H.span("Internal error!").cls("error"));
            }
            if (!this.jsonFormat()) {
                out.println(H.body().close());
                out.println(H.html().close());
            }
            out.close();
        }

        void getResults() throws IOException {
            this.setHeaders("application/json");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("a", "3");
            map.put("b", "4");
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(this.exchange.getResponseBody()));
            writer.println(Json.writeValueAsStringHard(map));
            writer.close();
        }

        void getFile(String path) throws IOException {
            if (!new File(path).exists()) {
                LogInfo.logs((String)"File doesn't exist: %s", (Object[])new Object[]{path});
                this.exchange.sendResponseHeaders(404, 0L);
                return;
            }
            this.setHeaders(this.getMimeType(path));
            if (Server.opts.verbose >= 2) {
                LogInfo.logs((String)"Sending %s", (Object[])new Object[]{path});
            }
            BufferedOutputStream out = new BufferedOutputStream(this.exchange.getResponseBody());
            FileInputStream in = new FileInputStream(path);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }

        class CandidatePredicates {
            List<Formula> predicates = new ArrayList<Formula>();
            List<Integer> spanLengths = new ArrayList<Integer>();
            List<Double> scores = new ArrayList<Double>();

            CandidatePredicates() {
            }

            void add(Formula formula, int spanLength, double score) {
                this.predicates.add(formula);
                this.spanLengths.add(spanLength);
                this.scores.add(score);
            }

            int size() {
                return this.predicates.size();
            }

            String formatPredicate(int i) {
                return this.predicates.get(i).toString() + (this.spanLengths.get(i) == 1 ? "" : " [" + this.spanLengths.get(i) + "]");
            }
        }
    }

    class Handler
    implements HttpHandler {
        Handler() {
        }

        @Override
        public void handle(HttpExchange exchange) {
            try {
                new ExchangeState(exchange);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class Options {
        @Option
        public int port = 8400;
        @Option
        public int numThreads = 4;
        @Option
        public String title = "SEMPRE Demo";
        @Option
        public String headerPath;
        @Option
        public String basePath = "demo-www";
        @Option
        public int verbose = 1;
        @Option
        public int htmlVerbose = 1;
    }
}

