/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Strings;
import edu.stanford.nlp.sempre.Builder;
import edu.stanford.nlp.sempre.ContextValue;
import edu.stanford.nlp.sempre.Dataset;
import edu.stanford.nlp.sempre.DateValue;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Learner;
import edu.stanford.nlp.sempre.Params;
import fig.basic.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Session {
    public final String id;
    public String remoteHost;
    public String format;
    public ContextValue context;
    Example lastEx;
    Params params;
    Learner learner;
    public Map<String, String> reqParams;
    public static Options opts = new Options();

    public Session(String id) {
        this.id = id;
        this.context = new ContextValue(id, DateValue.now(), new ArrayList<ContextValue.Exchange>());
    }

    public Example getLastExample() {
        return this.lastEx;
    }

    public String getLastQuery() {
        return this.lastEx == null ? null : this.lastEx.utterance;
    }

    public void updateContext() {
        this.context = this.context.withDate(DateValue.now());
    }

    public void updateContext(Example ex, int maxExchanges) {
        this.lastEx = ex;
        List<Derivation> derivations = this.lastEx.getPredDerivations();
        if (derivations.size() > 0) {
            Derivation deriv = derivations.get(0);
            ArrayList<ContextValue.Exchange> newExchanges = new ArrayList<ContextValue.Exchange>();
            newExchanges.addAll(this.context.exchanges);
            newExchanges.add(new ContextValue.Exchange(ex.utterance, deriv.formula, deriv.value));
            while (newExchanges.size() > maxExchanges) {
                newExchanges.remove(0);
            }
            this.context = this.context.withNewExchange(newExchanges);
        }
    }

    public void updateContextWithNewAnswer(Example ex, Derivation deriv) {
        ArrayList<ContextValue.Exchange> newExchanges = new ArrayList<ContextValue.Exchange>();
        for (int i = 0; i < this.context.exchanges.size() - 1; ++i) {
            newExchanges.add(this.context.exchanges.get(i));
        }
        newExchanges.add(new ContextValue.Exchange(ex.utterance, deriv.formula, deriv.value));
        this.context = this.context.withNewExchange(newExchanges);
    }

    public ContextValue getContextExcludingLast() {
        ArrayList<ContextValue.Exchange> newExchanges = new ArrayList<ContextValue.Exchange>();
        for (int i = 0; i < this.context.exchanges.size() - 1; ++i) {
            newExchanges.add(this.context.exchanges.get(i));
        }
        return this.context.withNewExchange(newExchanges);
    }

    public void useIndependentLearner(Builder builder) {
        this.params = new Params();
        if (!Strings.isNullOrEmpty((String)Session.opts.inParamsPath)) {
            this.params.read(Session.opts.inParamsPath);
        }
        this.learner = new Learner(builder.parser, this.params, new Dataset());
    }

    public String toString() {
        return String.format("%s: %s; last: %s", this.id, this.context, this.lastEx);
    }

    public boolean isLogging() {
        return this.defaultTrue("logging");
    }

    public boolean isWritingCitation() {
        return this.defaultTrue("cite");
    }

    public boolean isWritingGrammar() {
        return this.defaultTrue("grammar");
    }

    public boolean isLearning() {
        return this.defaultTrue("learn");
    }

    public boolean isStatsing() {
        return this.defaultTrue("stats");
    }

    private boolean defaultTrue(String key) {
        if (this.reqParams == null) {
            return true;
        }
        if (!this.reqParams.containsKey(key)) {
            return true;
        }
        return !this.reqParams.get(key).equals("0");
    }

    public static class Options {
        @Option
        public String inParamsPath;
    }
}

