/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.LanguageAnalyzer;
import edu.stanford.nlp.sempre.LanguageInfo;
import java.util.Arrays;

public class SimpleAnalyzer
extends LanguageAnalyzer {
    private static final String[] numbers = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};

    public static String breakHyphens(String utterance) {
        StringBuilder buf = new StringBuilder(utterance);
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) != '-' || i + 1 >= buf.length() || !Character.isLetter(buf.charAt(i + 1))) continue;
            buf.setCharAt(i, ' ');
        }
        return buf.toString();
    }

    @Override
    public LanguageInfo analyze(String utterance) {
        LanguageInfo languageInfo = new LanguageInfo();
        languageInfo.tokens.clear();
        languageInfo.posTags.clear();
        languageInfo.nerTags.clear();
        languageInfo.nerValues.clear();
        languageInfo.lemmaTokens.clear();
        utterance = SimpleAnalyzer.breakHyphens(utterance);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < utterance.length(); ++i) {
            boolean separate;
            boolean boundaryAfter;
            char c = utterance.charAt(i);
            boolean boundaryBefore = i - 1 < 0 || utterance.charAt(i - 1) == ' ';
            boolean bl = boundaryAfter = i + 1 >= utterance.length() || utterance.charAt(i + 1) == ' ';
            if (c == '.') {
                separate = boundaryBefore || boundaryAfter;
            } else {
                boolean bl2 = separate = ",?'\"[]".indexOf(c) != -1;
            }
            if (separate) {
                buf.append(' ');
            }
            if (c == '\"') {
                buf.append(boundaryBefore ? "``" : "''");
            } else if (c == '\'') {
                buf.append(boundaryBefore ? "`" : "'");
            } else {
                buf.append(c);
            }
            if (!separate) continue;
            buf.append(' ');
        }
        utterance = buf.toString().trim();
        if (!utterance.equals("")) {
            String[] tokens;
            for (String token : tokens = utterance.split("\\s+")) {
                languageInfo.tokens.add(LanguageAnalyzer.opts.lowerCaseTokens ? token.toLowerCase() : token);
                String lemma = token;
                if (token.endsWith("s") && token.length() > 1) {
                    lemma = token.substring(0, token.length() - 1);
                }
                languageInfo.lemmaTokens.add(LanguageAnalyzer.opts.lowerCaseTokens ? lemma.toLowerCase() : lemma);
                int x = Arrays.asList(numbers).indexOf(token);
                if (x != -1) {
                    languageInfo.posTags.add("CD");
                    languageInfo.nerTags.add("NUMBER");
                    languageInfo.nerValues.add(x + "");
                    continue;
                }
                try {
                    Double.parseDouble(token);
                    languageInfo.posTags.add("CD");
                    languageInfo.nerTags.add("NUMBER");
                    languageInfo.nerValues.add(token);
                }
                catch (NumberFormatException e) {
                    if (Character.isUpperCase(token.charAt(0))) {
                        languageInfo.posTags.add("NNP");
                    } else if (token.equals("'") || token.equals("\"") || token.equals("''") || token.equals("``")) {
                        languageInfo.posTags.add("''");
                    } else {
                        languageInfo.posTags.add("UNK");
                    }
                    languageInfo.nerTags.add("UNK");
                    languageInfo.nerValues.add("UNK");
                }
            }
        }
        return languageInfo;
    }
}

