/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Json;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.TypeInference;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.MapUtils;
import fig.basic.Option;
import fig.basic.StringDoubleVec;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SimpleLexicon {
    public static Options opts = new Options();
    private static SimpleLexicon lexicon;
    Map<String, List<Entry>> entries = new HashMap<String, List<Entry>>();

    public static SimpleLexicon getSingleton() {
        if (lexicon == null) {
            lexicon = new SimpleLexicon();
        }
        return lexicon;
    }

    private SimpleLexicon() {
        if (SimpleLexicon.opts.inPaths == null) {
            return;
        }
        for (String path : SimpleLexicon.opts.inPaths) {
            this.read(path);
        }
    }

    public void read(String path) {
        LogInfo.begin_track((String)"SimpleLexicon.read(%s)", (Object[])new Object[]{path});
        try {
            String line;
            BufferedReader in = IOUtils.openIn((String)path);
            int numLines = 0;
            int oldNumEntries = this.entries.size();
            while ((line = in.readLine()) != null) {
                Map<String, Object> map = Json.readMapHard(line);
                ++numLines;
                String rawPhrase = (String)map.get("lexeme");
                Formula formula = Formula.fromString((String)map.get("formula"));
                String typeStr = (String)map.get("type");
                SemType type = typeStr != null ? SemType.fromString(typeStr) : TypeInference.inferType(formula);
                StringDoubleVec features = null;
                Map featureMap = (Map)map.get("features");
                if (featureMap != null) {
                    features = new StringDoubleVec();
                    for (Map.Entry e : featureMap.entrySet()) {
                        features.add((String)e.getKey(), ((Double)e.getValue()).doubleValue());
                    }
                    features.trimToSize();
                }
                Entry entry = new Entry(rawPhrase, formula, type, features);
                String phrase = entry.rawPhrase.toLowerCase();
                MapUtils.addToList(this.entries, (Object)phrase, (Object)entry);
                String[] parts = phrase.split(" ");
                if (SimpleLexicon.opts.matchSuffixTypes == null || !SimpleLexicon.opts.matchSuffixTypes.contains(typeStr) || parts.length <= 1) continue;
                StringDoubleVec newFeatures = new StringDoubleVec();
                if (features != null) {
                    for (StringDoubleVec.Entry e : features) {
                        newFeatures.add(e.getFirst(), e.getSecond());
                    }
                }
                newFeatures.add("isSuffix", 1.0);
                newFeatures.trimToSize();
                Entry newEntry = new Entry(rawPhrase, formula, type, newFeatures);
                MapUtils.addToList(this.entries, (Object)parts[parts.length - 1], (Object)newEntry);
            }
            LogInfo.logs((String)"Read %s lines, generated %d entries (now %d total)", (Object[])new Object[]{numLines, this.entries.size() - oldNumEntries, this.entries.size()});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LogInfo.end_track();
    }

    public List<Entry> lookup(String phrase) {
        return (List)MapUtils.get(this.entries, (Object)phrase, (Object)Collections.EMPTY_LIST);
    }

    public static class Options {
        @Option(gloss="Path to load lexicon files from")
        public List<String> inPaths;
        @Option(gloss="Types to allow suffix (last word) matche (for people names")
        public List<String> matchSuffixTypes;
    }

    public static class Entry {
        public final String rawPhrase;
        public final Formula formula;
        public final SemType type;
        public final StringDoubleVec features;

        public Entry(String rawPhrase, Formula formula, SemType type, StringDoubleVec features) {
            this.rawPhrase = rawPhrase;
            this.formula = formula;
            this.type = type;
            this.features = features;
        }

        public String toString() {
            return "[" + this.rawPhrase + " => " + this.formula + " : " + this.type + "]";
        }
    }
}

