/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.FeatureExtractor;
import edu.stanford.nlp.sempre.FeatureVector;
import edu.stanford.nlp.sempre.MultipleDerivationStream;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SimpleLexicon;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.StringDoubleVec;
import java.util.ArrayList;
import java.util.List;

public class SimpleLexiconFn
extends SemanticFn {
    public static Options opts = new Options();
    private static SimpleLexicon lexicon;
    private SemType restrictType = SemType.topType;

    public SimpleLexiconFn() {
        lexicon = SimpleLexicon.getSingleton();
    }

    @Override
    public void init(LispTree tree) {
        super.init(tree);
        for (int i = 1; i < tree.children.size(); ++i) {
            LispTree arg = (LispTree)tree.child(i);
            if (!"type".equals(((LispTree)arg.child((int)0)).value)) continue;
            this.restrictType = SemType.fromLispTree((LispTree)arg.child(1));
        }
    }

    @Override
    public DerivationStream call(Example ex, SemanticFn.Callable c) {
        String phrase = c.childStringValue(0);
        List<SimpleLexicon.Entry> entries = lexicon.lookup(phrase);
        ArrayList<SimpleLexicon.Entry> newEntries = new ArrayList<SimpleLexicon.Entry>();
        for (SimpleLexicon.Entry e : entries) {
            if (SimpleLexiconFn.opts.verbose >= 3) {
                LogInfo.logs((String)"SimpleLexiconFn: %s => %s [type = %s meet-> %s]", (Object[])new Object[]{phrase, e.formula, e.type, this.restrictType.meet(e.type)});
            }
            if (!this.restrictType.meet(e.type).isValid()) continue;
            newEntries.add(e);
        }
        entries = newEntries;
        return new MyDerivationStream(ex, c, entries, phrase);
    }

    public class MyDerivationStream
    extends MultipleDerivationStream {
        private Example ex;
        private SemanticFn.Callable callable;
        private List<SimpleLexicon.Entry> entries;
        private String phrase;
        private int currIndex = 0;

        public MyDerivationStream(Example ex, SemanticFn.Callable c, List<SimpleLexicon.Entry> entries, String phrase) {
            this.ex = ex;
            this.callable = c;
            this.entries = entries;
            this.phrase = phrase;
        }

        @Override
        public int estimatedSize() {
            return this.entries.size();
        }

        @Override
        public Derivation createDerivation() {
            if (this.currIndex == this.entries.size()) {
                return null;
            }
            SimpleLexicon.Entry entry = this.entries.get(this.currIndex++);
            FeatureVector features = new FeatureVector();
            Derivation deriv = new Derivation.Builder().withCallable(this.callable).formula(entry.formula).type(entry.type).localFeatureVector(features).createDerivation();
            if (FeatureExtractor.containsDomain("basicStats") && entry.features != null) {
                for (StringDoubleVec.Entry e : entry.features) {
                    features.add("basicStats", e.getFirst(), e.getSecond());
                }
            }
            if (FeatureExtractor.containsDomain("lexAlign")) {
                deriv.addFeature("lexAlign", this.phrase + " --- " + entry.formula);
            }
            if (SemanticFn.opts.trackLocalChoices) {
                deriv.addLocalChoice("SimpleLexiconFn " + deriv.startEndString(this.ex.getTokens()) + " " + entry);
            }
            return deriv;
        }
    }

    public static class Options {
        @Option(gloss="Number of entities to return from entity lexicon")
        public int maxEntityEntries = 100;
        @Option(gloss="Verbosity level")
        public int verbose = 0;
    }
}

