/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;

public abstract class SingleDerivationStream
implements DerivationStream {
    private Derivation nextDeriv;
    private boolean consumed;

    public abstract Derivation createDerivation();

    @Override
    public boolean hasNext() {
        if (this.nextDeriv != null) {
            return true;
        }
        if (this.consumed) {
            return false;
        }
        this.nextDeriv = this.createDerivation();
        this.consumed = true;
        return this.nextDeriv != null;
    }

    @Override
    public Derivation peek() {
        if (!this.hasNext()) {
            throw new RuntimeException("No more derivations!");
        }
        return this.nextDeriv;
    }

    @Override
    public Derivation next() {
        if (!this.hasNext()) {
            throw new RuntimeException("No more derivations!");
        }
        Derivation deriv = this.nextDeriv;
        this.nextDeriv = null;
        return deriv;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Cannot remove from DerivationStream");
    }

    @Override
    public int estimatedSize() {
        return 1;
    }

    public static SingleDerivationStream constant(final Derivation deriv) {
        return new SingleDerivationStream(){

            @Override
            public Derivation createDerivation() {
                return deriv;
            }
        };
    }
}

