/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Function;
import edu.stanford.nlp.sempre.Formula;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;
import java.util.List;

public class SuperlativeFormula
extends Formula {
    public final Mode mode;
    public final Formula rank;
    public final Formula count;
    public final Formula head;
    public final Formula relation;

    public SuperlativeFormula(Mode mode, Formula rank, Formula count, Formula head, Formula relation) {
        this.mode = mode;
        this.rank = rank;
        this.count = count;
        this.head = head;
        this.relation = relation;
    }

    public static Mode parseMode(String mode) {
        if ("argmin".equals(mode)) {
            return Mode.argmin;
        }
        if ("argmax".equals(mode)) {
            return Mode.argmax;
        }
        return null;
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild((Object)((Object)this.mode) + "");
        tree.addChild((AbstractLispTree)this.rank.toLispTree());
        tree.addChild((AbstractLispTree)this.count.toLispTree());
        tree.addChild((AbstractLispTree)this.head.toLispTree());
        tree.addChild((AbstractLispTree)this.relation.toLispTree());
        return tree;
    }

    @Override
    public void forEach(Function<Formula, Boolean> func) {
        if (!((Boolean)func.apply((Object)this)).booleanValue()) {
            this.rank.forEach(func);
            this.count.forEach(func);
            this.head.forEach(func);
            this.relation.forEach(func);
        }
    }

    @Override
    public Formula map(Function<Formula, Formula> func) {
        Formula result = (Formula)func.apply((Object)this);
        return result == null ? new SuperlativeFormula(this.mode, this.rank.map(func), this.count.map(func), this.head.map(func), this.relation.map(func)) : result;
    }

    @Override
    public List<Formula> mapToList(Function<Formula, List<Formula>> func, boolean alwaysRecurse) {
        List res = (List)func.apply((Object)this);
        if (res.isEmpty() || alwaysRecurse) {
            res.addAll(this.rank.mapToList(func, alwaysRecurse));
            res.addAll(this.count.mapToList(func, alwaysRecurse));
            res.addAll(this.head.mapToList(func, alwaysRecurse));
            res.addAll(this.relation.mapToList(func, alwaysRecurse));
        }
        return res;
    }

    @Override
    public boolean equals(Object thatObj) {
        if (!(thatObj instanceof SuperlativeFormula)) {
            return false;
        }
        SuperlativeFormula that = (SuperlativeFormula)thatObj;
        if (this.mode != that.mode) {
            return false;
        }
        if (!this.rank.equals(that.rank)) {
            return false;
        }
        if (!this.count.equals(that.count)) {
            return false;
        }
        if (!this.head.equals(that.head)) {
            return false;
        }
        return this.relation.equals(that.relation);
    }

    @Override
    public int computeHashCode() {
        int hash = 2127912214;
        hash = hash * -744332180 + this.mode.toString().hashCode();
        hash = hash * -744332180 + this.rank.hashCode();
        hash = hash * -744332180 + this.count.hashCode();
        hash = hash * -744332180 + this.head.hashCode();
        hash = hash * -744332180 + this.relation.hashCode();
        return hash;
    }

    public static enum Mode {
        argmin,
        argmax;

    }
}

