/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Value;
import edu.stanford.nlp.sempre.Values;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import fig.basic.StrUtils;
import java.util.ArrayList;
import java.util.List;

public class TableValue
extends Value {
    public final List<String> header;
    public final List<List<Value>> rows;

    public int numRows() {
        return this.rows.size();
    }

    public int numCols() {
        return this.header.size();
    }

    public TableValue(LispTree tree) {
        this.header = new ArrayList<String>();
        this.rows = new ArrayList<List<Value>>();
        LispTree headerTree = (LispTree)tree.child(1);
        for (LispTree item : headerTree.children) {
            this.header.add(item.value);
        }
        for (int i = 2; i < tree.children.size(); ++i) {
            ArrayList<Value> row = new ArrayList<Value>();
            for (LispTree item : ((LispTree)tree.child((int)i)).children) {
                row.add(Values.fromLispTree(item));
            }
            this.rows.add(row);
        }
    }

    public TableValue(List<String> header, List<List<Value>> rows) {
        this.header = header;
        this.rows = rows;
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("table");
        LispTree headerTree = (LispTree)LispTree.proto.newList();
        for (String string : this.header) {
            headerTree.addChild(string);
        }
        tree.addChild((AbstractLispTree)headerTree);
        for (List list : this.rows) {
            LispTree rowTree = (LispTree)LispTree.proto.newList();
            for (Value value : list) {
                rowTree.addChild((AbstractLispTree)(value == null ? (LispTree)LispTree.proto.newLeaf(null) : value.toLispTree()));
            }
            tree.addChild((AbstractLispTree)rowTree);
        }
        return tree;
    }

    @Override
    public void log() {
        LogInfo.begin_track((String)"%s", (Object[])new Object[]{StrUtils.join(this.header, (String)"\t")});
        for (List<Value> row : this.rows) {
            LogInfo.logs((String)"%s", (Object[])new Object[]{StrUtils.join(row, (String)"\t")});
        }
        LogInfo.end_track();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableValue that = (TableValue)o;
        return this.rows.equals(that.rows);
    }

    @Override
    public int hashCode() {
        return this.rows.hashCode();
    }
}

