/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Value;
import fig.basic.LispTree;

public class TimeValue
extends Value {
    public final int hour;
    public final int minute;

    public TimeValue(int hour, int minute) {
        if (hour > 23 || hour < 0) {
            throw new RuntimeException("Illegal hour: " + hour);
        }
        if (minute > 59 || minute < 0) {
            throw new RuntimeException("Illegal minute: " + minute);
        }
        this.hour = hour;
        this.minute = minute;
    }

    public TimeValue(LispTree tree) {
        this.hour = Integer.valueOf(((LispTree)tree.child((int)1)).value);
        this.minute = Integer.valueOf(((LispTree)tree.child((int)2)).value);
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("time");
        tree.addChild(String.valueOf(this.hour));
        tree.addChild(String.valueOf(this.minute));
        return tree;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeValue timeValue = (TimeValue)o;
        if (this.hour != timeValue.hour) {
            return false;
        }
        return this.minute == timeValue.minute;
    }

    @Override
    public int hashCode() {
        int result = this.hour;
        result = 31 * result + this.minute;
        return result;
    }
}

