/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.ActionFormula;
import edu.stanford.nlp.sempre.AggregateFormula;
import edu.stanford.nlp.sempre.ArithmeticFormula;
import edu.stanford.nlp.sempre.CallFormula;
import edu.stanford.nlp.sempre.CallTypeInfo;
import edu.stanford.nlp.sempre.CanonicalNames;
import edu.stanford.nlp.sempre.DateValue;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Formulas;
import edu.stanford.nlp.sempre.FuncSemType;
import edu.stanford.nlp.sempre.JoinFormula;
import edu.stanford.nlp.sempre.LambdaFormula;
import edu.stanford.nlp.sempre.MarkFormula;
import edu.stanford.nlp.sempre.MergeFormula;
import edu.stanford.nlp.sempre.NameValue;
import edu.stanford.nlp.sempre.NotFormula;
import edu.stanford.nlp.sempre.NumberValue;
import edu.stanford.nlp.sempre.ReverseFormula;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SempreUtils;
import edu.stanford.nlp.sempre.StringValue;
import edu.stanford.nlp.sempre.SuperlativeFormula;
import edu.stanford.nlp.sempre.TimeValue;
import edu.stanford.nlp.sempre.TypeLookup;
import edu.stanford.nlp.sempre.ValueFormula;
import edu.stanford.nlp.sempre.VariableFormula;
import fig.basic.ImmutableAssocList;
import fig.basic.ListUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Ref;
import fig.basic.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class TypeInference {
    public static Options opts = new Options();
    private static TypeLookup typeLookup;
    private static Map<String, CallTypeInfo> callTypeInfos;
    private static final ValueFormula<NameValue> typeFormula;
    private static final Set<Formula> comparisonFormulas;

    private TypeInference() {
    }

    public static TypeLookup getTypeLookup() {
        if (typeLookup == null) {
            typeLookup = (TypeLookup)Utils.newInstanceHard((String)SempreUtils.resolveClassName(TypeInference.opts.typeLookup));
        }
        return typeLookup;
    }

    public static void setTypeLookup(TypeLookup typeLookup) {
        TypeInference.typeLookup = typeLookup;
    }

    public static void addCallTypeInfo(CallTypeInfo info) {
        if (callTypeInfos.containsKey(info.func)) {
            throw new RuntimeException("Already contains " + info.func);
        }
        callTypeInfos.put(info.func, info);
    }

    private static void initCallTypeInfo() {
        if (callTypeInfos != null) {
            return;
        }
        callTypeInfos = new HashMap<String, CallTypeInfo>();
        TypeInference.addCallTypeInfo(new CallTypeInfo("Math.cos", ListUtils.newList((Object[])new SemType[]{SemType.floatType}), SemType.floatType));
        TypeInference.addCallTypeInfo(new CallTypeInfo(".concat", ListUtils.newList((Object[])new SemType[]{SemType.stringType, SemType.stringType}), SemType.stringType));
        TypeInference.addCallTypeInfo(new CallTypeInfo(".length", ListUtils.newList((Object[])new SemType[]{SemType.stringType}), SemType.intType));
        TypeInference.addCallTypeInfo(new CallTypeInfo(".toString", ListUtils.newList((Object[])new SemType[]{SemType.anyType}), SemType.stringType));
    }

    public static SemType inferType(Formula formula) {
        return TypeInference.inferType(formula, TypeInference.getTypeLookup(), false);
    }

    public static SemType inferType(Formula formula, boolean allowFreeVariable) {
        return TypeInference.inferType(formula, TypeInference.getTypeLookup(), allowFreeVariable);
    }

    public static SemType inferType(Formula formula, TypeLookup typeLookup) {
        return TypeInference.inferType(formula, typeLookup, false);
    }

    public static SemType inferType(Formula formula, TypeLookup typeLookup, boolean allowFreeVariable) {
        SemType type;
        try {
            type = TypeInference.inferType(formula, new Env(typeLookup, allowFreeVariable), SemType.topType);
        }
        catch (TypeException e) {
            type = SemType.bottomType;
        }
        if (TypeInference.opts.verbose >= 2) {
            LogInfo.logs((String)"TypeInference: %s => %s", (Object[])new Object[]{formula, type});
        }
        return type;
    }

    private static SemType check(SemType type) throws TypeException {
        if (!type.isValid()) {
            throw new TypeException();
        }
        return type;
    }

    private static SemType inferType(Formula formula, Env env, SemType type) throws TypeException {
        if (TypeInference.opts.verbose >= 5) {
            LogInfo.logs((String)"TypeInference.inferType(%s, %s, %s)", (Object[])new Object[]{formula, env, type});
        }
        if (formula instanceof VariableFormula) {
            return TypeInference.check(env.updateType(((VariableFormula)formula).name, type));
        }
        if (formula instanceof ValueFormula) {
            Object value = ((ValueFormula)formula).value;
            if (value instanceof NumberValue) {
                return TypeInference.check(type.meet(SemType.numberType));
            }
            if (value instanceof StringValue) {
                return TypeInference.check(type.meet(SemType.stringType));
            }
            if (value instanceof DateValue) {
                return TypeInference.check(type.meet(SemType.dateType));
            }
            if (value instanceof TimeValue) {
                return TypeInference.check(type.meet(SemType.timeType));
            }
            if (value instanceof NameValue) {
                String id = ((NameValue)value).id;
                if (CanonicalNames.isUnary(id)) {
                    SemType unaryType = env.typeLookup.getEntityType(id);
                    if (unaryType == null) {
                        unaryType = SemType.entityType;
                    }
                    type = TypeInference.check(type.meet(unaryType));
                } else {
                    SemType propertyType = null;
                    if (CanonicalNames.SPECIAL_SEMTYPES.containsKey(id)) {
                        propertyType = CanonicalNames.SPECIAL_SEMTYPES.get(id);
                    } else if (!CanonicalNames.isReverseProperty(id)) {
                        propertyType = env.typeLookup.getPropertyType(id);
                    } else {
                        propertyType = env.typeLookup.getPropertyType(CanonicalNames.reverseProperty(id));
                        if (propertyType != null) {
                            propertyType = propertyType.reverse();
                        }
                    }
                    if (propertyType == null) {
                        propertyType = SemType.anyAnyFunc;
                    }
                    type = TypeInference.check(type.meet(propertyType));
                }
                return type;
            }
            throw new RuntimeException("Unhandled value: " + value);
        }
        if (formula instanceof JoinFormula) {
            JoinFormula join = (JoinFormula)formula;
            if (typeFormula.equals(join.relation) && join.child instanceof ValueFormula) {
                return TypeInference.check(type.meet(SemType.newAtomicSemType(Formulas.getString(join.child))));
            }
            if (comparisonFormulas.contains(join.relation)) {
                return TypeInference.check(type.meet(TypeInference.inferType(join.child, env, SemType.numberOrDateType)));
            }
            SemType relationType = TypeInference.inferType(join.relation, env, new FuncSemType(SemType.topType, type));
            SemType childType = TypeInference.inferType(join.child, env, relationType.getArgType());
            relationType = TypeInference.inferType(join.relation, env, new FuncSemType(childType, type));
            return TypeInference.check(relationType.getRetType());
        }
        if (formula instanceof MergeFormula) {
            MergeFormula merge = (MergeFormula)formula;
            type = TypeInference.check(type.meet(SemType.anyType));
            type = TypeInference.inferType(merge.child1, env, type);
            type = TypeInference.inferType(merge.child2, env, type);
            return type;
        }
        if (formula instanceof MarkFormula) {
            MarkFormula mark = (MarkFormula)formula;
            env = env.addVar(mark.var);
            type = TypeInference.check(type.meet(SemType.anyType));
            type = TypeInference.inferType(mark.body, env, type);
            type = TypeInference.check(env.updateType(mark.var, type));
            return type;
        }
        if (formula instanceof LambdaFormula) {
            LambdaFormula lambda = (LambdaFormula)formula;
            env = env.addVar(lambda.var);
            SemType bodyType = TypeInference.inferType(lambda.body, env, type.getRetType());
            SemType varType = TypeInference.check(env.updateType(lambda.var, type.getArgType()));
            return new FuncSemType(varType, bodyType);
        }
        if (formula instanceof NotFormula) {
            NotFormula not = (NotFormula)formula;
            type = TypeInference.check(type.meet(SemType.anyType));
            return TypeInference.inferType(not.child, env, type);
        }
        if (formula instanceof AggregateFormula) {
            AggregateFormula aggregate = (AggregateFormula)formula;
            TypeInference.inferType(aggregate.child, env, SemType.anyType);
            if (aggregate.mode == AggregateFormula.Mode.count) {
                return TypeInference.check(SemType.numberType.meet(type));
            }
            return TypeInference.check(SemType.numberOrDateType.meet(type));
        }
        if (formula instanceof ArithmeticFormula) {
            ArithmeticFormula arith = (ArithmeticFormula)formula;
            type = TypeInference.inferType(arith.child1, env, type);
            type = TypeInference.inferType(arith.child2, env, type);
            return TypeInference.check(type.meet(SemType.numberOrDateType));
        }
        if (formula instanceof ReverseFormula) {
            ReverseFormula reverse = (ReverseFormula)formula;
            SemType reverseType = TypeInference.inferType(reverse.child, env, type.reverse());
            return TypeInference.check(reverseType.reverse());
        }
        if (formula instanceof SuperlativeFormula) {
            SuperlativeFormula superlative = (SuperlativeFormula)formula;
            TypeInference.inferType(superlative.rank, env, SemType.numberType);
            TypeInference.inferType(superlative.count, env, SemType.numberType);
            type = TypeInference.check(type.meet(SemType.anyType));
            type = TypeInference.inferType(superlative.head, env, type);
            SemType relationType = TypeInference.inferType(superlative.relation, env, new FuncSemType(SemType.numberOrDateType, type));
            type = TypeInference.inferType(superlative.head, env, relationType.getRetType());
            return type;
        }
        if (formula instanceof CallFormula) {
            TypeInference.initCallTypeInfo();
            CallFormula call = (CallFormula)formula;
            if (!(call.func instanceof ValueFormula)) {
                return SemType.bottomType;
            }
            Object value = ((ValueFormula)call.func).value;
            if (!(value instanceof NameValue)) {
                return SemType.bottomType;
            }
            String func = ((NameValue)value).id;
            CallTypeInfo info = callTypeInfos.get(func);
            if (info == null) {
                return SemType.anyType;
            }
            if (info.argTypes.size() != call.args.size()) {
                return SemType.bottomType;
            }
            for (int i = 0; i < info.argTypes.size(); ++i) {
                TypeInference.inferType(call.args.get(i), env, info.argTypes.get(i));
            }
            return TypeInference.check(type.meet(info.retType));
        }
        if (formula instanceof ActionFormula) {
            TypeInference.initCallTypeInfo();
            return SemType.anyType;
        }
        throw new RuntimeException("Can't infer type of formula: " + formula);
    }

    static {
        typeFormula = new ValueFormula<NameValue>(new NameValue("fb:type.object.type"));
        comparisonFormulas = new HashSet<ValueFormula>(Arrays.asList(new ValueFormula<NameValue>(new NameValue("<")), new ValueFormula<NameValue>(new NameValue(">")), new ValueFormula<NameValue>(new NameValue("<=")), new ValueFormula<NameValue>(new NameValue(">="))));
    }

    private static class Env {
        private final TypeLookup typeLookup;
        private final boolean allowFreeVariable;
        private final ImmutableAssocList<String, Ref<SemType>> list;

        private Env(ImmutableAssocList<String, Ref<SemType>> list, TypeLookup typeLookup, boolean allowFreeVariable) {
            this.list = list;
            this.typeLookup = typeLookup;
            this.allowFreeVariable = allowFreeVariable;
        }

        public Env(TypeLookup typeLookup, boolean allowFreeVariable) {
            this((ImmutableAssocList<String, Ref<SemType>>)ImmutableAssocList.emptyList, typeLookup, allowFreeVariable);
        }

        public Env addVar(String var) {
            return new Env((ImmutableAssocList<String, Ref<SemType>>)this.list.prepend((Object)var, (Object)new Ref((Object)SemType.topType)), this.typeLookup, this.allowFreeVariable);
        }

        public SemType updateType(String var, SemType type) {
            SemType newType;
            Ref ref = (Ref)this.list.get((Object)var);
            if (ref == null) {
                if (!this.allowFreeVariable) {
                    throw new RuntimeException("Free variable not defined: " + var);
                }
                ref = new Ref((Object)SemType.topType);
            }
            if (!(newType = ((SemType)ref.value).meet(type)).isValid() && TypeInference.opts.verbose >= 2) {
                LogInfo.warnings((String)"Invalid type from [%s MEET %s]", (Object[])new Object[]{ref.value, type});
            }
            ref.value = newType;
            return newType;
        }

        public String toString() {
            String answer = this.typeLookup.getClass().getSimpleName() + " {";
            ImmutableAssocList now = this.list;
            while (!now.isEmpty()) {
                answer = answer + (String)now.key + ": " + now.value;
                now = now.next;
            }
            return answer + "}";
        }
    }

    private static class TypeException
    extends Exception {
        private TypeException() {
        }
    }

    public static class Options {
        @Option(gloss="Verbosity level")
        public int verbose = 1;
        @Option(gloss="Class for looking up types")
        public String typeLookup = "NullTypeLookup";
    }
}

