/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.TopSemType;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnionSemType
extends SemType {
    public final List<SemType> baseTypes = new ArrayList<SemType>();

    @Override
    public boolean isValid() {
        return this.baseTypes.size() > 0;
    }

    public UnionSemType() {
    }

    public UnionSemType(SemType ... baseTypes) {
        for (SemType baseType : baseTypes) {
            if (!baseType.isValid()) continue;
            this.baseTypes.add(baseType);
        }
    }

    public UnionSemType(Collection<SemType> baseTypes) {
        for (SemType baseType : baseTypes) {
            if (!baseType.isValid()) continue;
            this.baseTypes.add(baseType);
        }
    }

    @Override
    public SemType meet(SemType that) {
        if (that instanceof TopSemType) {
            return this;
        }
        ArrayList<SemType> result = new ArrayList<SemType>();
        for (SemType baseType : this.baseTypes) {
            result.add(baseType.meet(that));
        }
        return new UnionSemType(result).simplify();
    }

    @Override
    public SemType apply(SemType that) {
        ArrayList<SemType> result = new ArrayList<SemType>();
        for (SemType baseType : this.baseTypes) {
            result.add(baseType.apply(that));
        }
        return new UnionSemType(result).simplify();
    }

    @Override
    public SemType reverse() {
        ArrayList<SemType> result = new ArrayList<SemType>();
        for (SemType baseType : this.baseTypes) {
            result.add(baseType.reverse());
        }
        return new UnionSemType(result).simplify();
    }

    @Override
    public LispTree toLispTree() {
        LispTree result = (LispTree)LispTree.proto.newList();
        result.addChild("union");
        for (SemType baseType : this.baseTypes) {
            result.addChild((AbstractLispTree)baseType.toLispTree());
        }
        return result;
    }

    public SemType simplify() {
        if (this.baseTypes.size() == 0) {
            return SemType.bottomType;
        }
        if (this.baseTypes.size() == 1) {
            return this.baseTypes.get(0);
        }
        if (this.baseTypes.contains(SemType.topType)) {
            return SemType.topType;
        }
        return this;
    }
}

