/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.stanford.nlp.sempre.Values;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import java.util.Comparator;

public abstract class Value {
    public abstract LispTree toLispTree();

    public void log() {
        LogInfo.logs((String)"%s", (Object[])new Object[]{this.toString()});
    }

    @JsonValue
    public String toString() {
        return this.toLispTree().toString();
    }

    public String sortString() {
        return this.toString();
    }

    @JsonCreator
    public static Value fromString(String str) {
        return Values.fromLispTree((LispTree)LispTree.proto.parseFromString(str));
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static class ValueComparator
    implements Comparator<Value> {
        @Override
        public int compare(Value o1, Value o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

