/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.BooleanValue;
import edu.stanford.nlp.sempre.ContextValue;
import edu.stanford.nlp.sempre.DateValue;
import edu.stanford.nlp.sempre.DescriptionValue;
import edu.stanford.nlp.sempre.ErrorValue;
import edu.stanford.nlp.sempre.ListValue;
import edu.stanford.nlp.sempre.NameValue;
import edu.stanford.nlp.sempre.NumberValue;
import edu.stanford.nlp.sempre.StringValue;
import edu.stanford.nlp.sempre.TableValue;
import edu.stanford.nlp.sempre.TimeValue;
import edu.stanford.nlp.sempre.UriValue;
import edu.stanford.nlp.sempre.Value;
import fig.basic.LispTree;

public final class Values {
    private Values() {
    }

    public static Value fromLispTreeOrNull(LispTree tree) {
        if (tree.isLeaf()) {
            return null;
        }
        String type = ((LispTree)tree.child((int)0)).value;
        if ("name".equals(type)) {
            return new NameValue(tree);
        }
        if ("boolean".equals(type)) {
            return new BooleanValue(tree);
        }
        if ("number".equals(type)) {
            return new NumberValue(tree);
        }
        if ("string".equals(type)) {
            return new StringValue(tree);
        }
        if ("list".equals(type)) {
            return new ListValue(tree);
        }
        if ("table".equals(type)) {
            return new TableValue(tree);
        }
        if ("description".equals(type)) {
            return new DescriptionValue(tree);
        }
        if ("url".equals(type)) {
            return new UriValue(tree);
        }
        if ("context".equals(type)) {
            return new ContextValue(tree);
        }
        if ("date".equals(type)) {
            return new DateValue(tree);
        }
        if ("error".equals(type)) {
            return new ErrorValue(tree);
        }
        if ("time".equals(type)) {
            return new TimeValue(tree);
        }
        return null;
    }

    public static Value fromLispTree(LispTree tree) {
        Value value = Values.fromLispTreeOrNull(tree);
        if (value == null) {
            throw new RuntimeException("Invalid value: " + tree);
        }
        return value;
    }

    public static Value fromString(String s) {
        return Values.fromLispTree((LispTree)LispTree.proto.parseFromString(s));
    }
}

