/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre.test;

import edu.stanford.nlp.sempre.Grammar;
import edu.stanford.nlp.sempre.Rule;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GrammarTest {
    public static Grammar makeTernaryGrammar() {
        Grammar g = new Grammar();
        g.addStatement("(rule $ROOT ($X) (IdentityFn))");
        g.addStatement("(rule $X ($A $B $C) (IdentityFn))");
        g.addStatement("(rule $A (a) (ConstantFn (string a)))");
        g.addStatement("(rule $B (b) (ConstantFn (string b)))");
        g.addStatement("(rule $C (c) (ConstantFn (string c)))");
        return g;
    }

    public boolean isValidBinaryGrammar(Grammar g) {
        for (Rule rule : g.getRules()) {
            if (!Rule.isCat(rule.lhs)) {
                return false;
            }
            if (rule.rhs.size() == 1 || rule.rhs.size() == 2) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testBinarizationOfTernaryGrammar() {
        Grammar g = GrammarTest.makeTernaryGrammar();
        List<Rule> rules = g.getRules();
        Assert.assertEquals((int)6, (int)rules.size());
        Assert.assertTrue((boolean)this.isValidBinaryGrammar(g));
    }
}

