/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre.test;

import edu.stanford.nlp.sempre.Grammar;
import fig.basic.LogInfo;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class GrammarValidityTest {
    private String[] dataPaths = new String[]{"data/", "freebase/", "tables/", "regex/", "overnight/"};

    @Test(groups={"grammar"})
    public void readGrammars() {
        try {
            ArrayList successes = new ArrayList();
            ArrayList failures = new ArrayList();
            for (String dataPath : this.dataPaths) {
                Files.walk(Paths.get(dataPath, new String[0]), new FileVisitOption[0]).forEach(filePath -> {
                    try {
                        if (filePath.toString().toLowerCase().endsWith(".grammar")) {
                            Grammar test = new Grammar();
                            LogInfo.logs((String)"Reading grammar file: %s", (Object[])new Object[]{filePath.toString()});
                            test.read(filePath.toString());
                            LogInfo.logs((String)"Finished reading", (Object[])new Object[]{filePath.toString()});
                            successes.add(filePath.toString());
                        }
                    }
                    catch (Exception ex) {
                        failures.add(filePath.toString());
                    }
                });
            }
            LogInfo.begin_track((String)"Following grammar tests passed:", (Object[])new Object[0]);
            for (String path : successes) {
                LogInfo.logs((String)"%s", (Object[])new Object[]{path});
            }
            LogInfo.end_track();
            LogInfo.begin_track((String)"Following grammar tests failed:", (Object[])new Object[0]);
            for (String path : failures) {
                LogInfo.logs((String)"%s", (Object[])new Object[]{path});
            }
            LogInfo.end_track();
            AssertJUnit.assertEquals((int)0, (int)failures.size());
        }
        catch (Exception ex) {
            LogInfo.logs((String)ex.toString(), (Object[])new Object[0]);
        }
    }
}

